/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2011-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef USBTOOLS_H
#define USBTOOLS_H

/* usb.h functions have a timeout measured in milliseconds */
#define USB_SECONDS 1000

/* functions are using microsoconds in an attempt to be RTOS
 * cross platform  (as opposed to using ticks)
 */
#define USEC_PER_SECOND     1000000  /* one million */
#define USEC_PER_MILLISEC   1000     /* one thousand */
#define NANOSEC_PER_SECOND  1000000000 /* one BILLLION */
#define NANOSEC_PER_USEC    1000     /* one thousand */

#ifndef MIN
    #define MIN(x,y)  ( (x)<(y)?(x):(y) )
#endif

int find_device( libusb_device **scanner_dev, int vid, int pid, unsigned char *serial_number );
int open_device( libusb_device *dev, libusb_device_handle **dev_handle, int iface);
int close_device( struct libusb_device_handle *udev, int iface );
int get_serial_number( struct libusb_device_handle *udev, unsigned char *buf, int *buflen );
const char *get_libusb_error_string( enum libusb_error errnum );

#endif

