/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2011-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef ASPUSB_H
#define ASPUSB_H

int aspusb_read( struct libusb_device_handle *udev, int endpoint, unsigned char *buf, 
                    int bufsize, int timeout );
int aspusb_get_header( struct libusb_device_handle *udev, struct scan_header *pkt );
int aspusb_send_header( struct libusb_device_handle *udev, struct scan_header *pkt );
int aspusb_is_cancelled( void );
void aspusb_set_cancel( void );

void aspusb_set_scan_endpoints( libusb_device *dev, int iface, int new_out_endpoint, int new_in_endpoint );
int aspusb_get_scan_out_endpoint( void );
int aspusb_get_scan_in_endpoint( void );
int aspusb_get_scan_config_index( void );

#endif

