#!/usr/bin/python
#
# ===========================================================================
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright (c) 2011-2015, Marvell International Ltd.
#
# Alternatively, this software may be distributed under the terms of the GNU
# General Public License Version 2, and any use shall comply with the terms and
# conditions of the GPL.  A copy of the GPL is available at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
# IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
# ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
# this warranty disclaimer.
# ================================================================================

# 


# generated by m2l.py on 11-July-07
# 
# davep Nov-2007

ASP_COOKIE =  0x41535001  # "ASP\01" */

#/* Scan types */
SCAN_TYPE_MONO =   0
SCAN_TYPE_COLOR =  1
SCAN_TYPE_SCAN_THRU_COPY =   2  # capture copy data via scan-to-host (test/debug feature) */

#/* Scan message types */
SCAN_MSG_LOCK_SCAN_RESOURCE =       0
SCAN_MSG_RELEASE_SCAN_RESOURCE =    1
SCAN_MSG_START_SCAN_JOB =           2
SCAN_MSG_CANCEL_SCAN_JOB =          3
SCAN_MSG_ABORT_SCAN_JOB =           4
SCAN_MSG_SCAN_IMAGE_DATA =          5
SCAN_MSG_GET_SCAN_JOB_SETTINGS =    6
SCAN_MSG_SET_SCAN_JOB_SETTINGS =    7
SCAN_MSG_SET_DEFAULT_SCAN_JOB_SETTINGS =  8
SCAN_MSG_START_JOB =                9
SCAN_MSG_START_SHEET =              10
SCAN_MSG_START_PAGE =               11
SCAN_MSG_END_JOB =                  12
SCAN_MSG_END_SHEET =                13
SCAN_MSG_END_PAGE =                 14
SCAN_MSG_ADF_IS_PAPER_PRESENT =     15
SCAN_MSG_ADF_UNUSED1 =              16 # not implemented in FW */
SCAN_MSG_ADF_EJECT_SHEET =          17 # not implemented in FW */
SCAN_MSG_ADF_PICK_NEXT_SHEET =      18 # not implemented in FW */
SCAN_MSG_ENTER_STANDBY =            19 # not implemented in FW */
SCAN_MSG_ENTER_READY_STATE =        20 # not implemented in FW */
SCAN_MSG_RESET_XMIT_BUFFERS =       21 # WTF!?!?!?!?
SCAN_MSG_NEW_PAGE =                 24 # obsolete as of 2009; remove in future
SCAN_MSG_DATA_BLOB =                25 # opaque data ; originally created for cal-to-host metadata
SCAN_MSG_GET_PLATFORM_STRING =      26

#/* internal scan message types */
SCAN_MSG_INTERNAL_BASE =   65536
SCAN_MSG_ICEFILE_OPEN =  (SCAN_MSG_INTERNAL_BASE+1)
SCAN_MSG_ICEFILE_DATA =  (SCAN_MSG_INTERNAL_BASE+2)
SCAN_MSG_ICEFILE_CLOSE =  (SCAN_MSG_INTERNAL_BASE+3)

#/* Status response codes */
SCAN_STAT_SUCCESS =     0
SCAN_STAT_FAIL =        1
SCAN_STAT_BUSY =        2
SCAN_STAT_CMD_NOT_RECOGNIZED =  3
SCAN_STAT_INVALID_ARG =     4
SCAN_STAT_ADF_EMPTY =       5
SCAN_STAT_ADF_MISPICK =     6
SCAN_STAT_ADJ_JAM =         7

#/* Scan data types */
SCAN_DATA_NULL_TYPE  =      0  # uninitialized/none/invalid
SCAN_DATA_XRGB_PACKED =     1
SCAN_DATA_PLANAR =          2
SCAN_DATA_RED =             3
SCAN_DATA_GREEN =           4
SCAN_DATA_BLUE =            5
SCAN_DATA_MONO =            6
SCAN_DATA_MONO_HALFPACK_1BPP =  7
SCAN_DATA_MONO_HALFPACK_2BPP =  8
SCAN_DATA_MONO_HALFPACK_4BPP =  9
SCAN_DATA_BRG_INTERLACED = 10  # ICE Lite BRG (Blue Red Green) interlaced
SCAN_DATA_RGBX_PACKED = 11 # 4-byte pixel packed as RGB0 (RedGreenBlueZero)
SCAN_DATA_BRG_INTERLACED_MIRRORED = 12
SCAN_DATA_MONO_MIRRORED = 13
SCAN_DATA_RGB_PACKED = 14

# Scan job settings 'flags' field values 
SCAN_JOB_FLAGS_CAL_TO_HOST     = (1<<0)    # send calibration data instead of scan data 
SCAN_JOB_FLAGS_DOCUMENT_SOURCE = (0xff<<8) # 8-bit field containing document source 

SCAN_JOB_FLAGS_GET_DOCUMENT_SOURCE = lambda value : (((value)>>8)&0xff)
SCAN_JOB_FLAGS_SET_DOCUMENT_SOURCE = lambda value : (((value)&0xff)<<8)

# Values for the SCAN_JOB_FLAGS_DOCUMENT_SOURCE field 
SCAN_DOCUMENT_SOURCE_AUTO     = 0  # firmware decides (default)
SCAN_DOCUMENT_SOURCE_FLATBED  = 1 
SCAN_DOCUMENT_SOURCE_ADF      = 2

SCAN_LOCK_DISABLE_NOTCHFIND =   (1<<0)

COPY_QUALITY_DEFAULT =  0
COPY_QUALITY_TEXT =     1
COPY_QUALITY_DRAFT =    2
COPY_QUALITY_MIXED =    3
COPY_QUALITY_FILM_PHOTO =  4
COPY_QUALITY_PICTURE =     5
COPY_QUALITY_COLORCOPY =   6
COPY_QUALITY_LAST =  COPY_QUALITY_COLORCOPY # keep this updated! */

SCAN_ADF_STATUS_UNKNOWN =           0 # dunno */
SCAN_ADF_STATUS_NOT_ADF =           1 # device does not have an ADF */
SCAN_ADF_STATUS_PAPER_PRESENT =     2 # ADF thinks it has paper */
SCAN_ADF_STATUS_NO_PAPER_PRESENT =  3 # ADF think there is no paper */

SCAN_ICEFILE_OPEN_MAX_CHANNELS =  6

