/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2009-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


/**
 * \file taskqueue.h
 *
 * \brief Scan task task queue.
 *
 * A message queue with cancelable messages.
 */

#ifndef TASKQUEUE_H
#define TASKQUEUE_H

/* return values from scan_task_queue_get_task_status() */
#define TASK_QUEUE_NO_SUCH_TASK    1
#define TASK_QUEUE_TASK_IS_RUNNING 2
#define TASK_QUEUE_TASK_IS_PENDING 3

scan_err_t scan_task_queue_onetime_init( void );
void scan_task_queue_shutdown( void );
scan_err_t scan_task_queue_add_task( scan_msg_t *msg, uint32_t *id );
scan_err_t scan_task_queue_add_task_nowait( scan_msg_t *msg, uint32_t *id );
scan_err_t scan_task_queue_release_task( uint32_t id );
scan_err_t scan_task_queue_cancel_task( uint32_t id );
void scan_task_queue_get_task( scan_msg_t *msg, uint32_t *id );
int scan_task_queue_get_task_status( uint32_t id );
void scan_task_queue_print( void );

#endif

