/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2010-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/**
 * \file strtabletest.c
 *
 * \brief Regression tests for strtable.c
 *
 **/

#include <stdint.h>
#include <stdbool.h>

#include "lassert.h"
#include "utils.h"

#include "scantypes.h"
#include "scancore.h"
#include "scandbg.h"
#include "strtable.h"

scan_err_t string_table_test( void )
{
    scan_err_t scerr;
    struct string_table t, t2;
    char *ptr;

    scerr = string_table_new( &t, 1024, 32 );
    XASSERT( scerr==0, scerr );
    string_table_free( &t );

    scerr = string_table_new( &t, 1024, 32 );
    XASSERT( scerr==0, scerr );

    scerr = string_table_add_string( &t, "this is a very long string that should fail when we add it", &ptr );
    XASSERT( scerr==SCANERR_INVALID_PARAM, scerr );

    while( 1 ) {
        scerr = string_table_add_string( &t, "this is a test", &ptr );
        if( scerr==SCANERR_OUT_OF_MEMORY ) {
            break;
        }
        XASSERT( str_match( ptr, "this is a test", 14 ), (uint32_t)ptr );
    }
    scanlog_hex_dump( (unsigned char *)t.buf, t.maxlen_bytes );

    /* make a new one */
    scerr = string_table_new( &t2, t.maxlen_bytes*2, t.max_string_length );
    XASSERT( scerr==0, scerr );
    scerr = string_table_copy( &t2, &t );
    XASSERT( scerr==0, scerr );

    scanlog_hex_dump( (unsigned char *)t2.buf, t2.maxlen_bytes );

    string_table_free( &t );
    string_table_free( &t2 );

    return SCANERR_NONE;
}

