/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2010-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef STRTABLE_H
#define STRTABLE_H

struct string_table {
    char *buf;

    /* current number of bytes in the table (includes string NULLs) */
    int currlen_bytes;

    /* maximum number of bytes in the table (includes string NULLs) */
    int maxlen_bytes;

    /* maximum size of string stored in the table (required nonzero for buffer
     * range checks in string_table_add_string()
     */
    int max_string_length;
};

scan_err_t string_table_new( struct string_table *tbl, int num_bytes, int max_string_length );
void string_table_free( struct string_table *tbl );
scan_err_t string_table_copy( struct string_table *dst,
                              struct string_table *src );
scan_err_t string_table_add_string( struct string_table *tbl,
                                    const char *s, 
                                    char **new_ptr );

#endif

