/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2004-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/

#ifndef STRIP_PREDICT_H
#define STRIP_PREDICT_H

struct predict_state {
    /* state machine fields */
    int R;      /* remainder */
    int iPtr;   /* input strip pointer */
    int oPtr;   /* output strip pointer */
    int lastInputShipped;

    /* user parameters; constant across an image */
    int strip_height;
    int fracY;

    /* davep 27-june-06 ; 1==linear, 0==RAPR */
    int linear;
};

/* indices of values in strip[] array as returned by strip_next() */
#define STRIP_READ_FIRST  0
#define STRIP_READ_LAST   1
#define STRIP_WRITE_FIRST 2
#define STRIP_WRITE_LAST  3

#define STRIPPR_MODE_RAPR   1
#define STRIPPR_MODE_LINEAR 2

void strip_start( struct predict_state *s, 
                  int strip_height, 
                  int y_numerator,
                  int y_denominator, 
                  int fracY,
                  int mode );
void strip_next( struct predict_state *s, int strip[] );

#endif

