/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2011-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef SMIRB_H
#define SMIRB_H

#define SCANMAN_IOCTL_REQUEST_COOKIE 0x6849EE38

struct scanman_ioctl_request_block {
    /*
     *  Private fields.
     */
    /* passing around void pointers to this structure so must make sure we have
     * a pointer on the receiving end
     */
    uint32_t cookie;

    /* id is the request_id via scanman_dev_request(). Also the id in the
     * observer callback 
     */
    uint32_t id;

    /* 
     *  Public fields.
     */
    /* request/response fields (read/write by ioctl) */
    uint32_t request;
    int arg;
    void *ptr;

    /* response (result of smech_ioctl()) */
    scan_err_t scerr;
};

scan_err_t scanman_smirb_onetime_init( void );
scan_err_t scanman_smirb_alloc( struct scanman_ioctl_request_block **smirb );
void scanman_smirb_free( struct scanman_ioctl_request_block **smirb );
void scanman_smirb_sanity( struct scanman_ioctl_request_block *smirb );

#endif

