/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2004-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


#ifndef SIQPARSE_H
#define SIQPARSE_H

/* error codes returned by functions */
#define SIQERR_OUT_OF_MEM -1
#define SIQERR_INVALID    -2
#define SIQERR_TOO_LONG   -3
#define SIQERR_PARSE_FAIL -4
#define SIQERR_EOF        -5  
#define SIQERR_UNKNOWN_NAME -6

/* siqnames.c ; put in a separate file so I don't have to siqparse.l every time
 * we want to add a new name
 */
extern const struct siqdata_name g_siq_names[];

void siqparse_set_buffer( char *buffer, int buflen );
void siqparse_delete_buffer( void );
int siqparse_parse_file( struct siqdata_table *siqdata );
void siqparse_siqdata_free( struct siqdata *sd );

#endif

