/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2012-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/* \file cmd_proc_api.h
 *
 * \brief Clone(ish) of firmware command line cmd_proc functions.
 *
 * davep 12-Sep-2012
 */

#ifndef CMD_PROC_API
#define CMD_PROC_API

#define CMD_OK 0
#define CMD_ERROR -1
#define CMD_USAGE_ERROR -2

typedef int (*cmd_c_proc)(int argc, char* argv[]);

int cmd_register_cmd(const char* name, const char* shortalias,
                     const char* desc, const char* usage, const char* notes,
                     cmd_c_proc  proc);

int cmd_register_subcmd(const char* cmdname, const char* subname,
                const char* desc, const char* usage, const char* notes,
                cmd_c_proc  proc);

int cmd_printf(const char* f,...)        __attribute__ ((format (printf,1,2)));

int cmd_append_result(const char* f,...) __attribute__ ((format (printf,1,2)));

/* the following are not part of the OBA API */
void cmd_debug_dump( void );
int cmd_line_run( const char *cmdline );

#endif

