/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


/**
 * \file scantest.h
 *
 * \brief header file for scantest.c
 *
 */
 
#ifndef SCANTEST_H
#define SCANTEST_H

struct pic_handle_t;

scan_err_t scantest_simple_sensor( uint32_t scan_sensor, struct pic_handle_t *pic_handle );

scan_err_t scantest_with_data( uint32_t scan_sensor, struct pic_handle_t *pic_handle );

scan_err_t scantest_sensor( uint32_t scan_sensor, struct pic_handle_t *pic_handle, scan_cmode_t cmode, uint32_t dpi, uint32_t num_lines );

scan_err_t scantest_sensor_with_data( uint32_t scan_sensor, struct pic_handle_t *pic_handle, scan_cmode_t cmode, uint32_t dpi, uint32_t num_lines );

scan_err_t scantest_run_sensor_to_pic_test( void );

scan_err_t scantest_run_finger_test( void );

#endif

