/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2004-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/****************************************************************************** 
 * Description:
 *
 * Header file for scanpipe.c, the source which sets up PIC, PIE, and HalfPack.
 *
 *****************************************************************************/

#ifndef SCANPIPE_H
#define SCANPIPE_H

/* pipeline functions in scanpipe.c */

/* flags passed to pipe_start() to enable debug/test behavior in scanpipe.c */
#define PIPE_FLAG_NULL          0
#define PIPE_FLAG_LINK_RESULTS  (1<<1)
#define PIPE_FLAG_ONE_BUFFER    (1<<2)
/* 1<<3 available */
#define PIPE_FLAG_DATA_FROM_NET (1<<4)
#define PIPE_FLAG_DATA_FROM_ICEFILE (1<<5)

/* davep 20-Apr-2009 ; creating pipetap so we can more carefully tell where we
 * want to see the scan-to-net data  (pipetap named after pcap/ethertap)
 */
#define PIPETAP_NONE 0
#define PIPETAP_PIC  1
#define PIPETAP_PIE  2
#define PIPETAP_HP   3
#define PIPETAP_CUTTER 4

struct pic_handle_t;

scan_err_t pipe_onetime_init( void ); // one time cold init
void pipe_calc_rows( int expected_rows, int *scan_expected_rows, 
                     int *pie_expected_rows );
scan_err_t pipe_start( struct pic_handle_t **pic_handles, int pixels_per_row, int scan_expected_rows,
                 int pie_expected_rows, uint32_t pipe_flags );
scan_err_t pipe_wait( void );
void pipe_cancel( void );
void pipe_done( void );
int pipe_set_pipetap( int pipetap_location );

/* davep 07-Jan-2013 ; allow pipecut direct access to scanpipe rather than
 * function pointers
 */
#ifdef ICEDMA_H
scan_err_t pipecut_callback_send_to_scanman( uint8_t page_side, 
                                struct ice_dma_buffer *icebuf, 
                                bool last_buffer );
#endif

/* davep 08-Sep-2011 ; changing old old old old old extern to an accessor */
ATLISTENTRY *pipe_get_pipe_results( void );

#endif

