/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2006-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef SCANLIB_H
#define SCANLIB_H

/* forward declaration */
struct scanvars;
struct pic_handle_t;

scan_err_t scanlib_onetime_init( void );

scan_err_t scanlib2_setup( uint32_t pipe_flags );
void scanlib2_done( void );
scan_err_t scanlib2_run( uint32_t pipe_flags, struct pic_handle_t **pic_handle );
scan_err_t scanlib2_setup_and_run( struct scanvars **psv );
bool scanlib_is_locked( void );
scan_err_t scanlib_cancel_self( void );

void scanlib_send_page_start( uint8_t page_side );
void scanlib_send_page_end( uint8_t page_side );
void scanlib_send_scan_size( uint32_t pixels_per_row_padded, 
                             uint32_t pixels_per_row, uint32_t total_rows, uint32_t bits_per_pixel );
void scanlib_send_page_data( uint8_t **buf, scan_data_type dtype, 
                             uint32_t num_rows, uint32_t max_rows, 
                             int page_side, bool last_buffer );
void scanlib_send_scan_start( void );	/* patch by asa at 2017/06/16 */

scan_err_t scanlib_call_msg_callback( scan_msg_t *msg );

#endif // SCANLIB_H

