/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2011-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/**
 * \file scanif_mcfg.c
 *
 * \brief Scan Block Motor Config register interface.
 *
 **/

#include <stdint.h>
#include <stdbool.h>

#include "lassert.h"
#include "regAddrs.h"

#include "scantypes.h"
#include "scancore.h"
#include "scanblk_if.h"
#include "scanif.h"
#include "scandbg.h"

void scif_motor_setup(MOTOR_SEL motor_data_enable, MOTOR_SYNC lsmode, 
                      MOTOR_TYPE m1type, MOTOR_TYPE m2type)
{
    // FIXME - need to remove the motor_data_enable and m2type - no longer used.
    struct scanblk_MCFG_cfg mcfg;

    memset(&mcfg, 0x0, sizeof(struct scanblk_MCFG_cfg));
    mcfg.lsmode = lsmode;
    mcfg.mtype = m1type;
    mcfg.lsmode_valid = true;
    mcfg.mtype_valid = true;
    scanblk_set_MCFG(&mcfg);
}


