# ===========================================================================
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright (c) 2012-2015, Marvell International Ltd.
#
# Alternatively, this software may be distributed under the terms of the GNU
# General Public License Version 2, and any use shall comply with the terms and
# conditions of the GPL.  A copy of the GPL is available at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
# IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
# ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
# this warranty disclaimer.
# ================================================================================

 
# davep 27-Jun-2012; sick of having to modify so many projects when I add a new
# file so adding a core scan makefile

ifdef SCAN_TEST_CODE
    SCAN_SRC += pictest_common.c
endif

# davep 06-Sep-2012 ; need to add scancap.h to the "copy all these files to the
# toplevel .include" rule : WARNING this might break build systems not using
# the same Unity-ism
ifdef INSTALL_SRC
    INSTALL_SRC+=scancap.h
endif

# davep 25-Sep-2012 ; if we're using the new cal code, add the calcaplist which
# allows calgrapp.c to request specific scans from cal
ifneq (,$(findstring cal_common.c,$(SCAN_SRC)))
    SCAN_SRC+=calcaplist.c
endif

# davep 22-Oct-2012 ; cal strip overscan ; scan 1" around cal strip then find
# the cal strip in the data
SCAN_SRC+=findcalstrip.c

# davep 31-Oct-2012 ; move hardware independent PIC functions to own file so
# can be used by linux userspace
SCAN_SRC+=pic_common.c

# davep 15-Jan-2013 ; move some scanlib functions to own file so can share with
# linux userspace
SCAN_SRC+=scanlib_msg.c

# davep 23-Apr-2013 ; adding simple data structure to be able to share a block
# of fast memory (which is usually compile-time sized)
SCAN_SRC+=notaheap.c

# davep 22-May-2013 ; adding piemux.c, the PIE Multiplexer. Allows dual scan to
# context switch buffers through PIE
SCAN_SRC+=piemux.c

# davep 25-Jun-2013 ; adding stripdma.c which helps control multiplexing PIE
SCAN_SRC+=stripdma.c

# davep 02-Jul-2013 ; adding pipemap.c which maps channel numbers between the
# hardware/firmware blocks of the scan pipeline (scanpipe.c)
SCAN_SRC+=pipemap.c

