/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2012-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef SAFETYLOCK_H
#define SAFETYLOCK_H

#define SAFETY_LOCK_SEM_NAME_SIZE (10+1) /* +1 for NULL */

/* if you seen a failed assert on this value, we're probably trying to operate
 * on an uninitialized (or corrupted) semaphore
 */
#define SAFETY_LOCK_COOKIE 0x4EFD469D

#ifdef __KERNEL__
struct safety_lock {
    uint32_t cookie; /* used with validity tests */
    struct semaphore lock;
};
#else
struct safety_lock {
    uint32_t cookie; /* used with validity tests */
    sem_t lock;
};
#endif

void safety_lock_init( struct safety_lock *slock );

void safety_lock_free( struct safety_lock *slock );

scan_err_t safety_lock_try_lock( struct safety_lock *slock );

scan_err_t safety_lock_lock_with_timeout( struct safety_lock *slock, uint32_t timeout_in_usec );

void safety_lock_lock( struct safety_lock *slock );

void safety_lock_unlock( struct safety_lock *slock );

void safety_lock_test_self( void );

#endif

