/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef PIPEMAP_H
#define PIPEMAP_H

/* PIC WDMA <---> PIE RDMA */
uint8_t pipemap_pic_to_pie_channel( struct ice_dma_buffer *icebuf );
uint8_t pipemap_pie_to_pic_channel( struct ice_dma_buffer *icebuf );

/* PIE WDMA <---> PIE-HP RDMA */
uint8_t pipemap_pie_to_piehp_channel( struct ice_dma_buffer *icebuf );
uint8_t pipemap_piehp_to_pie_channel( struct ice_dma_buffer *icebuf );

/* Get the PIC WDMA channels associated with a particular sensor */
void pipemap_get_pic_channels_for_sensor( uint32_t sensor_num, uint8_t channel_array[] );

#endif

