/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2009-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


/**
 * \file pipecut_stub.c
 *
 * \brief pipe cutter stub functions for systems not needing the pipe cutter
 * (flatbed only systems)
 *
 */

#include "scos.h"

#include "ATypes.h"
#include "list.h"
#include "lassert.h"

#include "scantypes.h"
#include "scancore.h"
#include "scantools.h"
#include "icedma.h"
#include "pipecut.h"

void pipe_cutter_onetime_init( void )
{
}

scan_err_t pipe_cutter_open( UINT8 channels[], int num_channels, int num_readies ) 
{
    return SCANERR_NOT_IMPLEMENTED;
}

void pipe_cutter_close( void )
{
}


void pipe_cutter_flush( void )
{
}


void pipe_cutter_add_marker( UINT32 row_number, 
                             icebuf_cutter_callback callback,
                             unsigned long user_data )
{
}

void pipe_cutter_print_markers( void )
{
}


void pipe_cutter_add_data( UINT8 channel, struct ice_dma_buffer *icebuf )
{
    /* This function involve memory so don't mess around with a quiet ignore.
     * Fail hard and fail fast.
     */
    XASSERT(0,channel);
}

