/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2005-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/****************************************************************************** 
 *
 * Description:
 *
 * Documented power-on reset values for various PIE registers
 *
 *****************************************************************************/

#ifndef PIERESET_H
#define PIERESET_H

/* 
 *  Common registers have nothing needing reset.
 */

/*
 *  Read DMA
 */
#define PIE_RDMA_CCR_R   0x00000001
#define PIE_RDMA_CSR_R   0
#define PIE_RDMA_DCR_R   0
#define PIE_RDMA_DAR1_R  0
#define PIE_RDMA_DAR2_R  0
#define PIE_RDMA_DRCR1_R 0
#define PIE_RDMA_DRCR2_R 0
#define PIE_RDMA_DBCR_R  0
#define PIE_RDMA_DTCR_R  0

/*
 *  Bit depth enhance
 */
#define PIE_BDE_CFG_R 0x00000001


/* 
 *  RGB2esRGB
 */
#define PIE_CSC_RGB_CCR_R 0x00000001


/*
 *  esRGB2YCrCb
 */
#define PIE_CSC_ESR_CCR_R 0x00000001

/*
 *  YCrCb2esRGB
 */
#define PIE_CSC_YCC_CCR_R 0x00000001

/* 
 *  Color plane adjust
 */
#define PIE_CPA_CR_R 0x00000001


/* 
 *  Tone/contrast & neutral sensitivity
 */
#define PIE_TCNS_CR_R 0x000000001


/* 
 *  Pogo aligner
 */

#define PIE_ALIGN_PACR_R  0x00000306


/* 
 *  Multifilter Y/CrCb & Text Enhance
 */

#define PIE_FILTER_SCR1_R  0
#define PIE_FILTER_SCR2_R  0x00000100
#define PIE_FILTER_TEL1R_R 0
#define PIE_FILTER_TEL2R_R 0
#define PIE_FILTER_TEL3R_R 0

//SANDRA, can we remove this file yet????

/*
 *  Mono HalfPack
 */

#define PIE_HP_CFG_R   0x00000020
#define PIE_HP_ALGO_R  0
#define PIE_HP_BIAS_R  0
/* XXX should we reset the SRAMs as well? */

/* HalfPack read/write channel reset values */
#define PIE_HP_DMA_DAR_R 0
#define PIE_HP_DMA_LWR_R 0
#define PIE_HP_DMA_SCR_R 0
#define PIE_HP_DMA_TCR_R 0


/* 
 *  Write DMA
 */
/* 22-Mar-05 ; do NOT set rows to zero at any time. Causes serious problems
 * with the Write DMA state machines if PIE is reset while rows is zero. As of
 * this writing, the MA is incorrect and a new version is forthcoming.
 */
//#define PIE_WDMA_DGCR_R 0
#define PIE_WDMA_DGCR_R 0x0000000f

#define PIE_WDMA_DCR_R  0
#define PIE_WDMA_DAR_R  0
#define PIE_WDMA_DRCR_R 0 
#define PIE_WDMA_DBCR_R 0 
#define PIE_WDMA_DTCR_R 0 

#endif

