/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/**
 * \file piemux.h
 *
 * \brief Multiplex PIE (multiple separate images through PIE simultaneously)
 *
 * davep 23-May-2013
 *
 * Originally created to handle nsensor support (sensors on both sides of page)
 *
 */

#ifndef PIEMUX_H
#define PIEMUX_H

void piemux_onetime_init( void );
void piemux_dump( void );
void piemux_cancel( void );
scan_err_t piemux_open( void );
void piemux_close( void );

void piemux_add_ready( uint8_t page_side, struct ice_dma_buffer **p_icebuf );

scan_err_t piemux_scheduler( void );
void piemux_set_config( struct pie_handle_t *pie_handle, uint32_t channel );

void piemux_rdma_intmsg( uint8_t sensor_num, uint8_t pie_channel );
void piemux_wdma_intmsg( uint8_t sensor_num, uint8_t pie_channel );

#endif

