/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2011-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef PIEDMA_DESCRIP_H
#define PIEDMA_DESCRIP_H

struct pie_dma_descriptor {
    /* 
     * This section of the structure is used by the hardware, so all pointers
     * MUST be physical!
     */
    volatile uint32_t config_flags;
    volatile uint32_t transfer_len_bytes;
    volatile uint32_t dma_src_addr;         // Must be DMA pointer!
    volatile uint32_t dma_ptr_next_desc;    // Physical pointer to next descriptor
    volatile uint32_t dar1_start;
    volatile uint32_t dar1_end;
    volatile uint32_t dar2_start;
    volatile uint32_t dar2_end;

    /*
     * Hardware *SHOULD* ignore everything below this line.
     *
     * Have to pad the structure out to cache line size.  As of this writing,
     * cache line size is 32 bytes.
     */
    struct pie_dma_descriptor *virt_ptr_self;      // Virtual pointer to self
    struct pie_dma_descriptor *virt_ptr_next_desc; // Virtual pointer to next descriptor
    struct pie_dma_descriptor *dma_ptr_self;       // Physical pointer to self
    volatile uint32_t          padding[5];
};

/* values for pie_dma_descriptor.ctrl */
#define PIE_DMA_DESCRIPTOR_CONFIG_OWNER_CPU    (0<<24) 
#define PIE_DMA_DESCRIPTOR_CONFIG_OWNER_BLOCK  (1<<24) 
#define PIE_DMA_DESCRIPTOR_CONFIG_INT  (1<<1)  /* interrupt on descriptor transfer finish */
#define PIE_DMA_DESCRIPTOR_CONFIG_STOP (1<<0)  /* stop on descriptor transfer finish */

void pie_dma_dump_descriptor( struct pie_dma_descriptor *desc );
void pie_dma_flush_descriptor( struct pie_dma_descriptor *desc );

#ifdef _UDMA_REGMASKS_H_
void pie_idma_get_regs( uint8_t channel, volatile UDMA_REGS_t **pu, volatile POGO_IDMA_CORE_REGS_t **pi );
void pie_odma_get_regs( uint8_t channel, volatile UDMA_REGS_t **pu, volatile POGO_ODMA_CORE_REGS_t **po );
#endif

#endif

