/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2010-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


/**
 * \file picdma_descrip.c
 *
 * \brief PIC Write DMA driver for chained descriptor based DMA hardware
 *
 * davep 02-Apr-2010 ; adding 3-lut BDR test code
 *
 */

#include <stdint.h>

#include "scos.h"

#include "list.h"
#include "regAddrs.h"
#include "lassert.h"
#include "debug.h"
#include "memAPI.h"

#include "scantypes.h"
#include "scancore.h"
#include "scandbg.h"
#include "safetylock.h"
#include "icedma.h"

#include "pic_handle_if.h"
#include "pic_if.h"
#include "pic_convenience_if.h"

#include "pic.h"
#include "pictest.h"


static scan_err_t bdr_test_luts( uint8_t pic_instance )
{
    uint32_t *lut; 
//    volatile uint32_t *ptr32;
    int lut_numbytes;
//    int i;

    lut_numbytes = sizeof(uint32_t)*PIC_BDR_LUT_SIZE;

    lut = MEM_MALLOC( lut_numbytes );
    if( lut==NULL ) {
        return SCANERR_OUT_OF_MEMORY;
    }

#if 0
    // dzh - 01-07-15 since pic_bdr_xxx calls are only setting the values in cache with the new api,
    // the following code won't do as originally intended.
    dbg2( "%s load color0 LUT\n", __FUNCTION__ );
    memset( lut, 0xff, lut_numbytes );
    pic_bdr_select_lut(pic_instance, PIC_BDR_BDRCR_LUTSEL_COLOR0MONO);
    pic_bdr_set_lut(pic_instance, lut);

//    dbg2( "%s dump color0\n", __FUNCTION__ );
//    pic_bdr_dump(true);

    dbg2( "%s load color1 LUT\n", __FUNCTION__ );
    memset( lut, 0xee, lut_numbytes );
    pic_bdr_select_lut(pic_instance, PIC_BDR_BDRCR_LUTSEL_COLOR1);
    pic_bdr_set_lut(pic_instance, lut);
//    dbg2( "%s dump color1\n", __FUNCTION__ );
//    pic_bdr_dump(true);

//    dbg2( "%s dump color0\n", __FUNCTION__ );
//    pic_bdr_select_lut( PIC_BDR_BDRCR_LUTSEL_COLOR0MONO );
//    pic_bdr_dump(true);

    dbg2( "%s load color2 LUT\n", __FUNCTION__ );
    memset( lut, 0xdd, lut_numbytes );
    pic_bdr_select_lut(pic_instance, PIC_BDR_BDRCR_LUTSEL_COLOR2);
    pic_bdr_set_lut(pic_instance, lut);
//    dbg2( "%s dump color2\n", __FUNCTION__ );
//    pic_bdr_dump(true);

    /* verify! */
    pic_bdr_select_lut(pic_instance, PIC_BDR_BDRCR_LUTSEL_COLOR0MONO);

#endif

#if 0
    // ERROR - this code is trying to use hardware addresses - fixme to use driver
    ptr32 = PIC_BDR_LUT;
    for( i=0 ; i<PIC_BDR_LUT_SIZE ; i++ ) {
        XASSERT( *ptr32==0xff, *ptr32 );
    }
    pic_bdr_select_lut(pic_instance, PIC_BDR_BDRCR_LUTSEL_COLOR1);
    ptr32 = PIC_BDR_LUT;
    for( i=0 ; i<PIC_BDR_LUT_SIZE ; i++ ) {
        XASSERT( *ptr32==0xee, *ptr32 );
    }
    pic_bdr_select_lut(pic_instance, PIC_BDR_BDRCR_LUTSEL_COLOR2);
    ptr32 = PIC_BDR_LUT;
    for( i=0 ; i<PIC_BDR_LUT_SIZE ; i++ ) {
        XASSERT( *ptr32==0xdd, *ptr32 );
    }
#endif
    PTR_FREE( lut );

    return 0;
}

void bdr_3lut_test( uint8_t pic_instance )
{
    dbg2( "%s\n", __FUNCTION__ );

#if 0
    // With the new api, the registers won't be actually set until pic_do_configure.
    pic_bdr_set_bypass(pic_instance, true);
    pic_bdr_dump(pic_instance, false);
    pic_bdr_set_bypass(pic_instance,  false);
    pic_bdr_dump(pic_instance, false);

    pic_bdr_dump(pic_instance, false);
    pic_bdr_dump(pic_instance, false);

    pic_bdr_set_num_luts(pic_instance,  3);
    pic_bdr_dump(pic_instance, false);
#endif

#if 0    
    // ERROR - this code is trying to use hardware addresses - fixme to use driver
    XASSERT( *PIC_BDR_BDRCR & PIC_BDR_BDRCR_NUMLUTS(PIC_BDR_BDRCR_NUMLUTS_THREE), *PIC_BDR_BDRCR );

    pic_bdr_select_lut(pic_instance,  PIC_BDR_BDRCR_LUTSEL_COLOR0MONO);
    pic_bdr_dump(pic_instance, false);
    pic_bdr_select_lut(pic_instance,  PIC_BDR_BDRCR_LUTSEL_COLOR1);
    pic_bdr_dump(pic_instance, false);
    pic_bdr_select_lut(pic_instance,  PIC_BDR_BDRCR_LUTSEL_COLOR2);
    pic_bdr_dump(pic_instance, false);
#endif    

//    pic_bdr_dump(true);

    bdr_test_luts(pic_instance);
}

