/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2010-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


/**
 * \file picdma_descrip.h
 *
 * \brief PIC Write DMA driver for chained descriptor based DMA hardware
 *
 * davep 28-Mar-2010 ; Added for new descriptor-based DMAs
 *
 */

#ifndef PICDMA_DESCRIP_H
#define PICDMA_DESCRIP_H

struct pic_handle_t;

// void pic_cwdma_set_config( uint32_t disable_mode ); replaced by driver call pic_set_disable_mode_output_dma()

scan_err_t pic_cwdma_channel_open( uint8_t channel );
void pic_cwdma_channel_close( uint8_t channel );

void pic_cwdma_interrupt_stats_dump( void );

void pic_cwdma_late_launch( void );

#ifdef DDMA_H
void pic_ddma_desc_write( struct pic_handle_t *pic_handle, uint8_t channel, struct ddma_descriptor *desc, uint32_t line_width_bytes );
#endif

#endif

