/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef NOTAHEAP_H
#define NOTAHEAP_H

struct scanmem_block {
    scanmem_tag tag;
    uint32_t size_bytes;
    uint8_t *ptr;
    int instance;
};

#define NUM_SCANMEM_BLOCKS 4

struct notaheap {
    /* the counters are signed int to catch underflow */
    struct scanmem_block blocklist[NUM_SCANMEM_BLOCKS];
    int num_allocated;

    uint8_t *free_ptr;
    int free_size_bytes;

    uint8_t *base_ptr;
    int base_size_bytes;
};

scan_err_t notaheap_init( struct notaheap *scan_mem, uint8_t *mem_base, uint32_t mem_size_bytes );
uint8_t * notaheap_alloc( struct notaheap *scan_mem, scanmem_tag tag, uint32_t datalen, int instance );
void notaheap_free( struct notaheap *scan_mem, scanmem_tag tag, uint8_t *ptr, uint32_t datalen, int instance );
        
#endif

