/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2012-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#include <stdint.h>
#include <stdlib.h>
#include <string.h>

#include "scantypes.h"
#include "scancore.h"
#include "scandbg.h"
#include "mbuffer.h"

scan_err_t mbuffer_new( struct mbuffer *buf, int max )
{
    buf->max = 0;
    buf->len = 0;

    memset( buf, 0, sizeof(struct mbuffer) );

    buf->buf = (char *)malloc( max+1 );
    if( buf->buf==NULL ) {
        return SCANERR_OUT_OF_MEMORY;
    }
    buf->max = max;
    memset( buf->buf, 0, buf->max );
    return SCANERR_NONE;
}

void mbuffer_free( struct mbuffer *buf )
{
    if( buf->buf ) {
        free( buf->buf );
        buf->buf = NULL;
    }
    buf->len = 0;
    buf->max = 0;
}

scan_err_t mbuffer_realloc( struct mbuffer *buf )
{
    char *new_buf;

    /* double the max */
    new_buf = (char *)realloc( buf->buf, buf->max*2 );
    if( new_buf==NULL ) {
        dbg1( "%s failed to allocate bytes=%d\n", __FUNCTION__, buf->max*2 );
        return SCANERR_OUT_OF_MEMORY;
    }

    buf->buf = new_buf;
    buf->max = buf->max*2;

    return SCANERR_NONE;
}

