/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2012-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



//#line 2 "lex.yy.c"
/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

/* davep 07-Oct-2007 ; XXX shotgun debug for link error */
#ifdef __KERNEL__
typedef struct {
} FILE;
static FILE *stdin, *stdout;
#include <linux/slab.h>
#define free kfree
#define malloc(size) kmalloc(size, GFP_KERNEL)
#endif

#define YY_INPUT(buf,result,max_size) 
#define EOF -1
/* davep 07-Oct-2007 ; end shotgun debugs */

#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>
#include <errno.h>

/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#ifndef _WIN32
#include <unistd.h>
#endif

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif


/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)

typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 13
#define YY_END_OF_BUFFER 14
static yyconst short int yy_accept[30] =
    {   0,
        0,    0,   14,   12,   11,   10,   10,   12,    9,    8,
       12,    1,    1,    5,    3,    6,    7,   11,   10,    0,
        4,    9,    1,    1,    0,    3,    2,    2,    0
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    5,    6,    1,    1,    1,    1,    1,
        1,    1,    1,    7,    8,    1,    1,    9,   10,   10,
       10,   10,   10,   10,   10,   10,   10,    1,    1,    1,
       11,    1,    1,    1,   12,   12,   12,   12,   12,   12,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
        1,    1,    1,    1,   13,    1,   12,   12,   12,   12,

       12,   12,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   14,
       13,   13,   15,    1,   16,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[17] =
    {   0,
        1,    1,    2,    2,    1,    1,    1,    1,    3,    3,
        1,    4,    5,    6,    1,    1
    } ;

static yyconst short int yy_base[36] =
    {   0,
        0,    0,   52,   53,   49,   53,   47,   44,    0,   53,
        8,   25,   10,   53,    0,   53,   53,   36,   53,   27,
       53,    0,   12,   14,    0,    0,    0,    0,   53,   24,
       30,   34,   38,   42,   44
    } ;

static yyconst short int yy_def[36] =
    {   0,
       29,    1,   29,   29,   29,   29,   29,   30,   31,   29,
       29,   32,   29,   29,   33,   29,   29,   29,   29,   30,
       29,   31,   29,   29,   34,   33,   35,   35,    0,   29,
       29,   29,   29,   29,   29
    } ;

static yyconst short int yy_nxt[70] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   15,   15,   16,   17,   23,   23,   24,   24,
       24,   24,   24,   24,   20,   20,   20,   20,   20,   20,
       22,   21,   22,   22,   22,   22,   24,   18,   25,   24,
       26,   26,   26,   26,   27,   27,   28,   28,   21,   19,
       18,   29,    3,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29
    } ;

static yyconst short int yy_chk[70] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,   11,   11,   13,   13,
       23,   23,   24,   24,   30,   30,   30,   30,   30,   30,
       31,   20,   31,   31,   31,   31,   32,   18,   12,   32,
       33,   33,   33,   33,   34,   34,   35,   35,    8,    7,
        5,    3,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
//#line 1 "siqparse.l"
#define INITIAL 0
#define YY_NO_UNPUT 1
//#line 4 "siqparse.l"

#define TOK_DEC_NUMBER  1
#define TOK_HEX_NUMBER  2
#define TOK_OPEN_BRACE  3
#define TOK_CLOSE_BRACE 4
#define TOK_COMMA       5
#define TOK_EQUAL       6
#define TOK_ID          7
#define TOK_STRING      8
#define TOK_EOL        10
#define TOK_EOF        99
#define TOK_UNKNOWN   100

/* replace the stock fatal error function with an assert fail instead of 
 * an exit()
 */
void embedded_fatal_error( char *msg );
#define YY_FATAL_ERROR(msg) embedded_fatal_error( msg )

/* DAVEP_FIX_THIS  -- isatty() causes fits under the marvellarm c-library so
 * let's see if we can avoid using it
 * davep 07-Oct-2007 
 */
#define YY_NEVER_INTERACTIVE  1

/* davep 07-Oct-2007 ; XXX shotgun debug for link error */
#define ECHO 
/* davep 07-Oct-2007 ; end shotgun debugs */

/* uncomment EMBEDDED to build under our firmware */
#define EMBEDDED
//#define EMBEDDED

#ifdef EMBEDDED
    /* must include ThreadX as first file due to bletcherousness in memAPI.h */
//    #include "scos.h"
#endif

#include <string.h>

//#include "ATypes.h"
#include "utils.h"

#include "scantypes.h"
#include "siqdata.h"
#include "siqparse.h"


/* the following stuff is used to build under Cygwin/Linux */
#ifdef STANDALONE

#include <assert.h>
#include "log.h"

#define ASSERT assert
#define XASSERT(x,y) assert(x)

#define agMalloc(x,y) malloc(x)
#endif /* STANDALONE */


/* build under our embedded system */
#ifdef EMBEDDED
#include "memAPI.h"
#include "lassert.h"

#include "scancore.h"
#include "scandbg.h"

// #define malloc(x) MEM_MALLOC(x)
// #define free(x) memFree(x)

/* catch functions we shouldn't be calling with a linker error */    
//static void dont_call_exit( int n );
static void *internal_realloc( void *ptr, int size );
#define exit    dont_call_exit
#define realloc internal_realloc

#define YY_MALLOC_DECL 
#endif /* EMBEDDED */


int lineno=1;

//#define PARSE_DEBUG  1
#define PARSE_DEBUG  0
//#line 475 "lex.yy.c"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#ifdef YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

//#line 99 "siqparse.l"


//#line 640 "lex.yy.c"

	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 30 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 53 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
//#line 101 "siqparse.l"
return TOK_DEC_NUMBER;
	YY_BREAK
case 2:
YY_RULE_SETUP
//#line 102 "siqparse.l"
return TOK_HEX_NUMBER;
	YY_BREAK
case 3:
YY_RULE_SETUP
//#line 103 "siqparse.l"
return TOK_ID;
	YY_BREAK
case 4:
YY_RULE_SETUP
//#line 104 "siqparse.l"
return TOK_STRING;
	YY_BREAK
case 5:
YY_RULE_SETUP
//#line 106 "siqparse.l"
return TOK_EQUAL;
	YY_BREAK
case 6:
YY_RULE_SETUP
//#line 107 "siqparse.l"
return TOK_OPEN_BRACE;
	YY_BREAK
case 7:
YY_RULE_SETUP
//#line 108 "siqparse.l"
return TOK_CLOSE_BRACE;
	YY_BREAK
case 8:
YY_RULE_SETUP
//#line 109 "siqparse.l"
return TOK_COMMA;
	YY_BREAK
case 9:
YY_RULE_SETUP
//#line 111 "siqparse.l"
/* eat up one-line comments */
	YY_BREAK
case 10:
YY_RULE_SETUP
//#line 113 "siqparse.l"
{ lineno++; }
	YY_BREAK
case 11:
YY_RULE_SETUP
//#line 114 "siqparse.l"
/* eat up whitespace */
	YY_BREAK
case 12:
YY_RULE_SETUP
//#line 116 "siqparse.l"
return TOK_UNKNOWN;
	YY_BREAK
case 13:
YY_RULE_SETUP
//#line 118 "siqparse.l"
ECHO;
	YY_BREAK
//#line 788 "lex.yy.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
        /* davep 03-Dec-2008 ; add return to quiet a warning */
        return 0;

	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 30 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;
	register char *yy_cp = yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 30 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 29);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;


	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef _WIN32
#include <unistd.h>
#else
#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#ifdef YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *yy_str )
#else
YY_BUFFER_STATE yy_scan_string( yy_str )
yyconst char *yy_str;
#endif
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
/* davep 07-Oct-2007 ; XXX remove this function because fprintf() causing
 * problems with marvellarm linke
 */
#if 0
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
#endif
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#ifdef YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
//#line 118 "siqparse.l"


int yywrap( void )
{
    return 1;
}

void embedded_fatal_error( char *msg )
{
    /* replace yy_fatal_error() which calls exit() */

    dbg1( "%s\n", msg );
    ASSERT(0);
    while(1) {
    }
}


void parse_debug( int token, const char *value )
{
#if PARSE_DEBUG > 1
    dbg2( "token=%d value=\"%s\"\n", token, yytext );
#endif
}

static void 
print_siqdata( struct siqdata *sd )
{
#if PARSE_DEBUG > 0
    int i;

    if( sd==NULL ) {
        dbg2( "siqdata=(null)\n" ));
    }
    else {
        dbg2( "siqdata=%d num=%#lx (%ld) array=%p num_values=%d max_values=%d\n", 
                sd->key, sd->num32, sd->num32, sd->num32_values, sd->num_values,
                sd->max_values ));
        dbg2( "value=" );
        if( sd->num32_values ) {
            for( i=0 ; i<sd->num_values ; i++ ) {
                dbg2( "%ld ", sd->num32_values[i] );
            }
            dbg2( "\n" );
        }
        else if( sd->str ) {
            dbg2( "%s\n", sd->str ); }

    }
#endif
}

static int
find_key( const char *name, int namelen, int *key )
{
    const struct siqdata_name *sdname;

#if PARSE_DEBUG > 0
    dbg2( "%s \"%s\"\n", __FUNCTION__, name );
#endif

    /* linear search for the name in our list */
    sdname = g_siq_names;
    while( 1 ) {
        if( sdname->len == 0 ) {
            break;
        }

        /* case insensitive */
        if( namelen==sdname->len && strncasecmp( sdname->str, name, sdname->len ) == 0 ) {
            *key = sdname->key;
            return 0;
        }

        /* more to the next entry in our list of known names */
        sdname++;
    }

    return SIQERR_UNKNOWN_NAME;
}

static int
siq_find_symbol( struct siqdata_table *siqdata, struct siqdata *sd )
{
    int i;

    for( i=0 ; i<siqdata->num_entries ; i++ ) {
        if( siqdata->data[i].key == sd->key ) {
            return i;
        }
    }
    return -1;
}

void
siqparse_siqdata_free( struct siqdata *sd )
{
    /*
     *  only edit this file in siqparse.l! 
     */
    
    if( sd->num32_values != NULL ) {
        XASSERT( sd->num_values <= sd->max_values, sd->num_values );
        PTR_FREE( sd->num32_values );
    }
    if( sd->str ) {
        XASSERT( sd->num_values <= sd->max_values, sd->num_values );
        PTR_FREE( sd->str );
    }
    sd->key = 0;
    sd->num32 = 0;
    sd->num_values = 0;
    sd->max_values = 0;
    /* TODO - if add any more value arrays, don't forget to free them here */
}

static void
merge_duplicate( struct siqdata_table *siqdata, int idx, struct siqdata *new_sd)
{
    struct siqdata *curr_sd;

    dbg2( "%s %d\n", __FUNCTION__, idx );

    /* free the current data then block copy the new structure on top of the
     * old 
     */
    curr_sd = &siqdata->data[idx];
    siqparse_siqdata_free( curr_sd );

    memcpy( curr_sd, new_sd, sizeof(struct siqdata) );

    /* wipe out original data so we don't have any duplicate pointers running
     * around
     */
    memset( new_sd, 0, sizeof(struct siqdata) );
}

static int parse_index( const char *name, struct siqdata *sd, int *namelen )
{
    /* If 'name' ends with __index3 (etc), put 3 in sd->index_value

       New grammar rules really ought to be in the original input file for flex,
       but at the moment it's dead. I put some effort into reviving it, but the output
       (via flex) needs to be worked on quite a bit to make it compile in the kernel.
       I've given up. I'm hacking it in here. I'm sorry.
    */
    int retcode;
    uint32_t num32;
    char *num, *loc;

    *namelen = strlen(name);

    loc = strstr(name, SIQ_INDEXED_STR);
    if(loc) {
        num = loc + strlen(SIQ_INDEXED_STR); // add length of '__index' to get to the numbers
        
        retcode = str_mkint( num, &num32 );
        if( retcode != 0 ) {
            dbg1( "parse error: bad integer \"%s\"\n", num );
            return SIQERR_PARSE_FAIL;
        }
        sd->index_value = num32;
        sd->index_is_set = true;
        *namelen -= strlen(loc); // subtract back length of '__index3' (for example)
    }

    return 0;
}

static int
parse_name( const char *name, struct siqdata *sd )
{
    int retcode;
    int key;
    int namelen;

    /* Set sd->index_value if applicable */
    retcode = parse_index(name, sd, &namelen);
    if( retcode ) {
        return retcode;
    }

    retcode = find_key( name, namelen, &key );
    if( retcode==SIQERR_UNKNOWN_NAME ) {
        return retcode;
    }
    if( sd!=NULL ) {
        sd->key = key;
    }
    return 0;
}

static int
get_token( int *token )
{
    *token = yylex();
    if( *token==0 ) {
        /* end of file */
        *token = TOK_EOF; 
        return SIQERR_EOF;
    }

    parse_debug( *token, yytext );

    return 0;
}

static int
alloc_value_list( uint32_t **ppnum32, int count )
{
    *ppnum32 = MEM_MALLOC( count * sizeof(uint32_t) );
    if( *ppnum32 == NULL ) {
        dbg1( "parse error: out of memory\n" );
        return SIQERR_OUT_OF_MEM;
    }
    dbg3( "value_list=%p\n", *ppnum32 );
    memset( *ppnum32, 0, count * sizeof(uint32_t) );
    return 0;
}

static int
realloc_value_list( uint32_t **ppnum32, int old_count, int new_count )
{
    uint32_t *pnum32_old;

#if PARSE_DEBUG > 0
    dbg2( "%s %p from %d to %d\n", __FUNCTION__, *ppnum32, old_count, new_count );
#endif

    pnum32_old = *ppnum32;

    *ppnum32 = MEM_MALLOC( new_count * sizeof(uint32_t) );
    if( *ppnum32 == NULL ) {
        dbg1( "parse error: out of memory\n" );
        return SIQERR_OUT_OF_MEM;
    }
    dbg3( "new value list=%p old value list=%p\n", *ppnum32, pnum32_old );
    memset( *ppnum32, 0, new_count * sizeof(uint32_t) );
    memcpy( *ppnum32, pnum32_old, old_count * sizeof(uint32_t) );
    PTR_FREE( pnum32_old );
    return 0;
}
 
static int
parse_value_list( struct siqdata *sd )
{
    int token;
    int end_of_list;
    int retcode;
    int last_token;
    uint32_t num32;

    /* first symbol we see should be a number so pretend we're already inside
     * the list 
     */
    last_token = TOK_COMMA;

    /* allocate a chunk of data for numbers */
    if( sd != NULL ) {
        XASSERT( sd->num32_values==NULL, (uint32_t)sd->num32_values );
        retcode = alloc_value_list( &sd->num32_values, 64 );
        if( retcode != 0 ) {
            return retcode;
        }
        sd->num_values = 0;
        sd->max_values = 64;
    }

    /* next symbols should be ( "," number ) | "}"  */
    end_of_list = 0;
    while( !end_of_list ) {

        retcode = get_token( &token );
        if( retcode != 0 ) {
            dbg1( "parse error: unexpected eof\n" );
            return retcode;
        }

        switch( token ) {

            case TOK_CLOSE_BRACE :
                end_of_list = 1;
                break;

            case TOK_DEC_NUMBER :
            case TOK_HEX_NUMBER :
                if( last_token != TOK_COMMA ) {
                    dbg1( "parse error: expected \",\" not \"%s\"\n", yytext );
                    return SIQERR_PARSE_FAIL;
                }
                retcode = str_mkint( yytext, &num32 );
                if( retcode != 0 ) {
                    dbg1( "parse error: bad integer \"%s\"\n", yytext );
                    return SIQERR_PARSE_FAIL;
                }
                if( sd != NULL ) {
                    sd->num32_values[ sd->num_values ] = num32;
                    sd->num_values++;
                    if( sd->num_values >= sd->max_values ) {
                        retcode = realloc_value_list( &sd->num32_values,
                                     sd->max_values, sd->max_values*2 );
                        if( retcode != 0 ) {
                            return retcode;
                        }
                        sd->max_values *= 2;
                    }
                }
                break;

            case TOK_COMMA :
                /* too many commas in a row */
                if( last_token != TOK_DEC_NUMBER && last_token != TOK_HEX_NUMBER ) {
                    dbg1( "parse error: expected integer at \"%s\"\n", yytext );
                    return SIQERR_PARSE_FAIL;
                }
                /* otherwise just ignore commas */
                break;

            case TOK_EOL :
                /* ignore */
                break;

            default :
                dbg1( "parse error: unexpected token \"%s\" in parse\n", yytext );
                return SIQERR_PARSE_FAIL;
        }

        last_token = token;
    }

    return 0;
}

static int 
parse_statement( const char *id, struct siqdata *sd )
{
    int retcode;
    int token;
    uint32_t num32;

#if PARSE_DEBUG > 0
    dbg2( "%s \"%s\"\n", __FUNCTION__, id );
#endif

    /* we need to parse the name before getting the next token since we're
     * passing yytext into this function and yytext will change as soon as we
     * call the lexer again
     */
    retcode = parse_name( id, sd );
    if( retcode == SIQERR_UNKNOWN_NAME ) {
        dbg1( "parse warning: ignore unknown name \"%s\"\n", id );
        
        /* we have to keep parsing but we won't save any data */
        sd = NULL;
    }

    /* statement := id "=" value */
    retcode = get_token( &token );
    if( retcode != 0 ) {
        dbg1( "parse error: unexpected eof\n" );
        return retcode;
    }

    if( token != TOK_EQUAL ) {
        dbg1( "parse error: expected \"=\" found \"%s\"\n", yytext );
        return SIQERR_PARSE_FAIL;
    }

    retcode = get_token( &token );
    if( retcode != 0 ) {
        dbg1( "parse error: unexpected eof\n" );
        return retcode;
    }

    /* value := "{" value_list "} 
     *        |  decimal_integer
     *        |  hex_integer
     */
    switch( token ) {
        case TOK_OPEN_BRACE :
            retcode = parse_value_list( sd );
            if( retcode != 0 ) {
                /* parse_value_list() logs error */
                return retcode;
            }
            break;

        case TOK_STRING :
            if( sd == NULL ) {
                break;
            }

            /* make a copy of the string; +1 for NULL */
            XASSERT( sd->str==NULL, (uint32_t)sd->str );

            sd->str = MEM_MALLOC( yyleng+1 );
            dbg2( "sd->str=%p\n", sd->str );
            if( sd->str==NULL ) {
                dbg2( "out of memory, dropping string\n" );
            }
            else {
                memset( sd->str, 0, yyleng+1 );
                /* copy in such a way we kill the surrounding quotes */
                strncpy( sd->str, &yytext[1], yyleng-2 );
                sd->max_values = yyleng-2;
                sd->num_values = yyleng-2;

                dbg2( "string=\"%s\"\n", sd->str );
            }
            break;

        case TOK_DEC_NUMBER :
        case TOK_HEX_NUMBER :
#if PARSE_DEBUG > 0
            dbg2( "found number %s\n", yytext );
#endif
            retcode = str_mkint( yytext, &num32 );
            if( retcode != 0 ) {
                dbg2( "parse error: bad integer \"%s\"\n", yytext );
                return SIQERR_PARSE_FAIL;
            }
            if( sd != NULL ) {
                sd->num32 = num32;
            }
            break;

        default :
            dbg2( "parse error: unexpected token \"%s\"\n", yytext );
            return SIQERR_PARSE_FAIL;
    }

    if( sd==NULL ) {
        return SIQERR_UNKNOWN_NAME;
    }

    return 0;
}

int 
siqparse_parse_file( struct siqdata_table *siqdata )
{
    int retcode;
    int token;
    int error;
    struct siqdata *sd;

    /* do not edit this code except in siqparse.l! */

    siqdata->num_entries = 0;

    error = 0;
    while( !error ) {
        if( siqdata->num_entries >= siqdata->max_entries ) {
            dbg1( "parse error: out of space for siqdata (max=%d)\n", siqdata->max_entries );
            return SIQERR_OUT_OF_MEM;
        }

        sd = &siqdata->data[ siqdata->num_entries ];

        retcode = get_token( &token );
        if( retcode != 0 ) {
            if( token == TOK_EOF ) {
                break;
            }
            else {
                error = 1;
                break;
            }
        }

        switch( token ) {
            case TOK_ID:
                /* statements start with an ID */
                retcode = parse_statement( yytext, sd );
                if( retcode != 0 ) {
                    /* ignore unknown names */
                    if( retcode != SIQERR_UNKNOWN_NAME) {
                        error = 1;
                        break;
                    }
                }
                else {
                    print_siqdata( sd );

                    /* check for duplicate symbols; always take the newest value unless
                     * index_is_set, in which case we allow duplicates
                     */
                    retcode = siq_find_symbol( siqdata, sd );
                    if( retcode < 0 || sd->index_is_set ) {
                        /* we have a successful parse; use this slot */
                        siqdata->num_entries++;
                    }
                    else {
                        /* don't increment num_entries so we'll reuse the
                         * slot the next time around
                         */
                        merge_duplicate( siqdata, retcode, sd );
                    }
                }
                break;

            case TOK_EOL :
                /* blank line, line comment - ignore */
                break;

            default :
                dbg1( "parse error line=%d, token=%d yytext=\"%s\"\n", lineno, token, yytext );
                error = 1;
                break;
        }

//        if( error != 0 ) {
//            printf( "parse fail on line %d token \"%s\"\n", lineno, yytext );
//        }

    }

    /* did we find anything? treat an empty file as an error; only report this
     * error if the parse was successful so we don't have an annoying
     * calvalcade of error messages
     */
    if( !error ) {
        if( siqdata->num_entries == 0 ) {
            dbg1( "no symbols found; empty file is an error\n" );
            error = 1;
        }
    }

    dbg2( "%s done error=%d\n", __FUNCTION__, error );
    return error;
}

static YY_BUFFER_STATE yystate;

void siqparse_set_buffer( char *buffer, int buflen )
{
    buffer[buflen] = YY_END_OF_BUFFER_CHAR;
    buffer[buflen+1] = YY_END_OF_BUFFER_CHAR;

    /* +2 for the flex end-of-buffer chars */
    yystate = yy_scan_buffer( buffer, buflen+2 );
    ASSERT( yystate != 0 );
}

void siqparse_delete_buffer( void )
{
    yy_delete_buffer( yystate );
}

void siqparse_dont_call( void )
{
    /* you call this function you die */
    ASSERT(0);

    /* call unused functions to quiet the compiler warning */
    yy_fatal_error( "" );

    /* davep 03-Dec-2010 ; call input() */
    input();
}

#ifdef EMBEDDED
//static void 
//dont_call_exit( int n )
//{
//    ASSERT(0);
//}

static void *internal_realloc( void *ptr, int size )
{
    return realloc( ptr, size );
}

#endif

