/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2004-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef ICEFILTER_H
#define ICEFILTER_H

/* we have 6 channels max: red,green,blue and even,odd */
#define ICE_FILTER_NUM_CHANNELS  6

void ice_filter_init( void );
int ice_filter_open( uint8_t channels[], 
                            uint8_t num_channels,
                            int total_rows,
                            int bytes_per_row );
void ice_filter_add_ready( uint8_t channel, struct ice_dma_buffer **addme );
void ice_filter_channel_launch( uint8_t channel );
void ice_filter_sanity( void );
void ice_filter_close( void );
//void ice_filter_close( void );
void ice_filter_cancel( void );

/* The following functions are necessary to plug into the ICEDMA architecture
 * but aren't actually used in the software filter plug-in because we're 
 * software. Most of the functions are NOPs.
 */ 
void ice_filter_channel_reset( uint8_t channel );
void ice_filter_channel_start( uint8_t channel );
void ice_filter_channel_enable( uint8_t channel );
bool ice_filter_channel_is_enabled( uint8_t channel );
void ice_filter_channel_disable( uint8_t channel );
void ice_filter_channel_load( uint8_t channel, uint8_t *data_ptr, dma_addr_t dma_dest, 
                              uint32_t rows, uint32_t bytes_per_row );
void ice_filter_isr( uint8_t channel );

#endif

