/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2006-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


/**
 * \file icefile.h
 *
 * \brief header file for icefile.c
 *
 * Icefile is a debug tool that reads copy data from USB. The data is read
 * through the scan endpoint and injected into the scanpipe as if it came from
 * PIC.
 *
 */

#ifndef ICEFILE_H
#define ICEFILE_H

/* This is legacy from the days of PIC WDMA. Icetest has one and only one dma
 * channel. TODO remove.
 */
#define ICEFILE_NUM_CHANNELS  6

struct icefile_packet
{
    uint32_t cookie;
    uint32_t opcode; 
    uint32_t seqnum; /* USB has problems with packet replay */
    uint32_t flags;  /* future proofing */
    uint32_t length; /* header+data length, like UDP */
};

#define ICEFILE_PACKET_COOKIE 0x1b5b356d

#define ICEFILE_OP_OPEN  1
#define ICEFILE_OP_CLOSE 2
#define ICEFILE_OP_DATA  3
#define ICEFILE_OP_ERROR 4
#define ICEFILE_OP_ACK   5

struct icefile_open
{
    uint32_t num_channels;
    uint32_t channels[ICEFILE_NUM_CHANNELS];
};

struct icefile_data
{
    uint32_t channel;
    uint32_t num_rows;
    uint32_t bytes_per_row;
    uint32_t datalen_bytes;
};

/** size info of icebuf data sent by icefile to the scanpipe */
struct icefile_image_info 
{
    uint32_t total_rows;
    uint32_t pixels_per_row;
    uint32_t rows_per_buffer;
};

/* TODO */
//void icefile_cancel_msg( void );

/* general icefile functions */
scan_err_t icefile_set_image_info( struct icefile_image_info *image_info ); 
scan_err_t icefile_get_image_info( struct icefile_image_info *image_info );
int icefile_load_pd_lut(int pixel_width);
int icefile_get_rows_per_buffer( void );

#endif

