/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2012-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/**
 * \file grayline.h
 *
 * \brief functions for linear brightness/contrast 
 *
 */

#ifndef GRAYLINE_H
#define GRAYLINE_H

struct rectangular
{
    float x, y;
};

struct line 
{
    struct rectangular p1, p2;
};

void grayline_new( struct line *line, 
                   float p1_x, float p1_y,
                   float p2_x, float p2_y );

void grayline_to_lut( int num_entries, uint32_t lut[], struct line *line );

void grayline_enhance_contrast( float float_contrast, 
                                struct line *line_in,
                                struct line *line_out );

#endif

