/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2004-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


/****************************************************************************** 
 *
 * Description: APIs for Figure class/object.
 *
 *****************************************************************************/

#ifndef FIGURE_H_
#define FIGURE_H_

typedef struct FigBufferTag{
    char *buf;
    struct FigBufferTag *next;
}FigBuffer;

/**\brief The document struct for calibration graph report
 */
typedef struct FigureTag
{
	DISP_LIST *contentHead;
	FigBuffer *buffer;
	void (*drawTitle)(struct FigureTag *pFig, const char *title); 
	void (*drawText)(struct FigureTag *pFig, int font, const char *text, int x,int y);
	void (*drawLine)(struct FigureTag *pFig,  int x1, int y1,int x2, int y2, int lineWidth, int lineStyle);
	void (*drawCurve)(struct FigureTag *pFig, int length, int x0, int y0, UINT16 *data, int lineWidth, int lineStyle, float x_inc, float y_inc);
	void (*drawPixels)(struct FigureTag *pFig,int length, UINT16 *x, UINT16 *y, int mode);
	void (*getGraphBoxDim)(int *x1, int *y1, int *x2, int *y2);
	void (*getTextBoxDim)(int *x1, int *y1, int *x2, int *y2);
}Figure;

Figure *createTitledFigure(const char *title);
Figure *createBlankFigure();
void destroyFigure(Figure *pFig);

#endif /*FIGURE_H_*/

