/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2010-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


/*
 *
 *  CISX management code.
 *
 *  davep 19-Nov-2010
 */

#ifndef CISX_H
#define CISX_H

#define CISX_MAX_ODMA_PER_BLK  3
#define CISX_MAX_IDMA_PER_BLK  1

/* davep 29-Jan-2013 ; adding dual sensor support */
#ifdef HAVE_NSENSOR_SUPPORT
#define CISX_ODMA_NUM_CHANNELS (CISX_MAX_ODMA_PER_BLK * 2)
#define CISX_IDMA_NUM_CHANNELS (CISX_MAX_IDMA_PER_BLK * 2)
#else
#define CISX_ODMA_NUM_CHANNELS (CISX_MAX_ODMA_PER_BLK)
#define CISX_IDMA_NUM_CHANNELS (CISX_MAX_IDMA_PER_BLK)
#endif

/* CISX DMA channels. Note that these may also be used internally as array
*  indexes (so be careful when editing).
*/
typedef enum {
    CISX0_ODMA0 = 0,
    CISX0_ODMA1,
    CISX0_ODMA2,
    CISX1_ODMA0,
    CISX1_ODMA1,
    CISX1_ODMA2,
} cisx_odma_chan_t;

typedef enum {
    CISX0_IDMA0 = 0,
    CISX1_IDMA0,
} cisx_idma_chan_t;

/* interrupt name changes depending on your ASIC */
#ifndef INTNUM_CISX
#define INTNUM_CISX INTNUM_ICE_CISX
#endif

struct sensor_segment {
    const int num_dummy;
    const int num_data;
    const int append_flag;
};

/* two or three will be normal */
#define CISX_SENSOR_MAX_SEGMENTS 12

struct cisx_sensor_conf {
    int num_segments;
    struct sensor_segment segments[CISX_SENSOR_MAX_SEGMENTS];
    uint8_t chan_order;  /* one of CISX_3CHAN_ORDER_nnn */

    /* davep 25-Mar-2013 ; allow Cfg.cbiout_pace to be platform specific. 
     *
     * "CBI Output Pacing"
     *
     * VallidOut frequency = BusClkFreq/(cbiout_pace + 2) 
     * ValidOut frequency (max) = BusClkFreq/2
     */
    uint32_t cbiout_pace;
};

void cisx_dump( void );
void cisx_dma_dump( void );
void cisx_ddma_dump( void );
scan_err_t cisx_onetime_init( void );
scan_err_t cisx_cleanup_module( void );

void cisx_interrupt_disable( void );
void cisx_interrupt_enable( void );

void cisx_set_cmode( scan_cmode_t cmode );
void cisx_set_pixels( cisx_odma_chan_t channel, uint32_t num_dummy_pixels, uint32_t num_data_pixels, int append_flag );
void cisx_reset( void );
scan_err_t cisx_soft_setup( void );
void cisx_set_bypass( bool bypass );
void cisx_set_cbiout_pace( uint32_t cbiout_pace );
void cisx_sanity( void );
scan_err_t cisx_open( scan_cmode_t cmode, 
                      const struct cisx_sensor_conf *cisxsensor,
                      uint32_t sensor_bitmask);
void cisx_launch( void );
void cisx_close( void );
void cisx_ddma_data_peek( void );
bool cisx_get_dual_channel_enabled( void );

void cisx_odma_channel_reset( cisx_odma_chan_t channel );
void cisx_odma_channel_disable( cisx_odma_chan_t channel );
void cisx_odma_channel_enable( cisx_odma_chan_t channel );
void cisx_odma_channel_start( cisx_odma_chan_t channel );

void cisx_idma_channel_reset( cisx_idma_chan_t channel );
void cisx_idma_channel_disable( cisx_idma_chan_t channel );
void cisx_idma_channel_enable( cisx_idma_chan_t channel );
void cisx_idma_channel_start( cisx_idma_chan_t channel );

void cisx_get_pixels_per_row( uint32_t *ppr );
uint32_t cisx_get_int_pending( void );

#endif

