/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2012-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/**
 * \file chipgap.h
 *
 * \brief functions for fixing chipgap with memcpy and linear interpolation
 *
 * davep 01-Feb-2012
 */

#ifndef CHIPGAP_H
#define CHIPGAP_H

void chipgap_debug_print_segments( void );

void chipgap_precalculate_segment_positions( uint32_t pic_left_margin, 
                                             uint32_t pic_right_margin, 
                                             int bits_per_pixel );

void chipgap_interpolate_row_8bpp( uint8_t *p_src_row, uint8_t *p_dst_row, int bytes_per_row  );
void chipgap_interpolate_row_16bpp( uint8_t *p_src_row, uint8_t *p_dst_row, int bytes_per_row  );

scan_err_t chipgap_set_positions( uint32_t first_gap, uint32_t gap_distance );
void chipgap_get_positions( uint32_t *first_gap, uint32_t *gap_distance );

#endif

