/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#include <linux/module.h> /* Needed by all modules */
#include <linux/kernel.h> /* Needed for KERN_INFO */
#include <linux/init.h>

#include "scos.h"

#include "scantypes.h"
#include "scancore.h"
#include "scandbg.h"
#include "scantask.h"
#include "scansen.h"
#include "scanvars.h"
#include "chipgap.h"
#include "scanmech.h"
#include "adfsensor.h"
#include "scanmem.h"
#include "pic_handle_if.h"
#include "pic_if.h"

static int __init scantask_init_module(void)
{
    dbg2( "%s\n", __FUNCTION__ );

    /* 
     * A non 0 return means init_module failed; module can't be loaded. 
     */
    return 0;
}

static void __exit scantask_cleanup_module(void)
{
    dbg2( "%s\n", __FUNCTION__ );
}

module_init( scantask_init_module );
module_exit( scantask_cleanup_module );

EXPORT_SYMBOL(scantask_init);
EXPORT_SYMBOL(scantask_scan_start);
EXPORT_SYMBOL(scantask_cmd_line_run);

EXPORT_SYMBOL(scanvar_delete);
EXPORT_SYMBOL(scanvar_sanity);
EXPORT_SYMBOL(scanvar_set_scan_callback);
EXPORT_SYMBOL(scanvar_set_dpi);
EXPORT_SYMBOL(scanvar_from_siqfile);

EXPORT_SYMBOL(chipgap_set_positions);
EXPORT_SYMBOL(chipgap_get_positions);

EXPORT_SYMBOL(scanmech_adf_client_request_pause);
EXPORT_SYMBOL(scanmech_adf_client_clear_pause);

EXPORT_SYMBOL(scanmech_get_fb_margins);
EXPORT_SYMBOL(scanmech_debug_set_fb_margins);
EXPORT_SYMBOL(scanmech_get_adf_margins);
EXPORT_SYMBOL(scanmech_debug_set_adf_margins);

EXPORT_SYMBOL(smech_ioctl);

EXPORT_SYMBOL(adf_sensor_paper_present);

EXPORT_SYMBOL(scanmem_free_aligned);
EXPORT_SYMBOL(scanmem_get_fast_memory);
EXPORT_SYMBOL(scanmem_free_fast_memory);

EXPORT_SYMBOL(pic_set_external_pd_lut_provider);

#ifdef HAVE_SCAN_ICEFILE_SUPPORT
#include "icefile.h"
EXPORT_SYMBOL(icefile_get_image_info);
#endif

MODULE_AUTHOR("Copyright (c) 2013-2016 Marvell International Ltd.");
MODULE_DESCRIPTION("Marvell series ScanTask Driver");

MODULE_LICENSE("Dual MPL/GPL");
MODULE_VERSION("2013_SEP_20");

