/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2011-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#include <linux/module.h> /* Needed by all modules */
#include <linux/kernel.h> /* Needed for KERN_INFO */
#include <linux/slab.h>

#include "memAPI.h"
#include "utils.h"

static mlimiter_t scan_stub_mlimiter;

void *scanK_MEM_MALLOC_ALIGN( size_t size, tAlign align )
{
    void *ptr;

    ptr = kmalloc( size, GFP_KERNEL|GFP_DMA );
    return ptr;
}

void *scanK_MEM_MALLOC( size_t size )
{
    void *ptr;
    ptr = kmalloc( size, GFP_KERNEL );
    return ptr;
}

void scanK_memFree(void *address)
{
    kfree( address );
}

mlimiter_t * mlimiter_by_name( const char * name )
{
    if( str_match( name, "scan", 4 ) ) {
        return &scan_stub_mlimiter;
    }

    return NULL;
}

void mlimiter_start( mlimiter_t *limiter )
{
}

void mlimiter_stop( mlimiter_t *limiter )
{
}

void mlimiter_adjust_limits( mlimiter_t *limiter, uint32_t lowest_max, uint32_t highest_max )
{
}

