/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2010-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



/**
 * \file icetest_threadx.c
 *
 * \brief ICETest code to work portably (ha ha) across RTOS selections.
 *
 * ICETest has an interrupt. We must wait on the interrupt. In order to work
 * across RTOS differences, put the interrupt and OS specific bits in own file.
 *
 */

#include <linux/module.h> /* Needed by all modules */
#include <linux/kernel.h> /* Needed for KERN_INFO */
#include <linux/completion.h>
#include <linux/interrupt.h>

#include "scos.h"

#include "lassert.h"

#include "scantypes.h"
#include "scancore.h"
#include "icetest.h"

#ifndef INIT_COMPLETION
// Cope with change between 3.9 and 3.13 kernels
#define INIT_COMPLETION(x) reinit_completion(&(x))
#endif

/* forward decl */
static void icetest_tasklet( unsigned long arg );

static DECLARE_TASKLET(icetest_isr_tasklet,icetest_tasklet,0);
static DECLARE_COMPLETION(icetest_isr_complete);

static void icetest_tasklet( unsigned long arg )
{
    complete_all( &icetest_isr_complete );
}

void icetest_interrupt_rtos_wait( void )
{
    wait_for_completion( &icetest_isr_complete );

    /* reset to allow it to be re-used */
    INIT_COMPLETION( icetest_isr_complete );
}

void icetest_interrupt_rtos_signal( void )
{
    /* 
     * BIG FAT NOTE! This is called from interrupt context! 
     */
    tasklet_schedule( &icetest_isr_tasklet );
}

void icetest_rtos_init( void )
{
    INIT_COMPLETION( icetest_isr_complete );
}

