/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2011-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#include <linux/module.h> /* Needed by all modules */
#include <linux/kernel.h> /* Needed for KERN_INFO */
#include <linux/slab.h>
#include <linux/delay.h>

#include "cpu_api.h"

void cpu_spin_delay(uint32_t delayInUs)
{
    udelay( delayInUs );
}

void cpu_dcache_writeback_region( void *start_addr, uint32_t size_in_bytes )
{
    /* ??? */
}

void cpu_dcache_invalidate_region( void *start_addr, uint32_t size_in_bytes )
{
    /* ??? */
}

uint32_t cpu_get_dcache_line_size( void )
{
/* common/devices/cpu/88sv331x-v5/src/88sv331x-v5.c */
#define CACHE_LINE_SIZE 32      // the cache line size

    /* documentation says data cache line size is 32 bytes */
    return CACHE_LINE_SIZE;
}


