/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2004-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef SCANMAN_H
#define SCANMAN_H

/* davep 13-Sep-2011 ; RIP Status Manager. Replace with something new. */
typedef enum {
    SCANMAN_EVENT_NULL=0, /* invalid/uninitialized */
    SCANMAN_EVENT_IDLE=1,
    SCANMAN_EVENT_SCAN_START=2,
    SCANMAN_EVENT_SCAN_RUNNING=3,
    SCANMAN_EVENT_SCAN_CALIBRATION_RUNNING=4,
    SCANMAN_EVENT_SCAN_CALIBRATION_COMPLETE=5,
    SCANMAN_EVENT_SCAN_COMPLETE=6,

    SCANMAN_EVENT_SCAN_CANCEL=7,
    SCANMAN_EVENT_SCAN_OFFLINE=8,

    /* scan subsystem is initializing, not ready for scanning */
    SCANMAN_EVENT_INITIALIZING=10,
    SCANMAN_EVENT_INITIALIZED=11,

    SCANMAN_EVENT_ADF_PAPER_PRESENT=20,
    SCANMAN_EVENT_ADF_PAPER_JAM=21,
    SCANMAN_EVENT_ADF_PAPER_NOPICK=22,


    /* the dev request id will be in the 'value' field of the callback data */
    SCANMAN_EVENT_DEV_REQUEST_SUCCESS=100, /* dev request accepted and successfully completed */
    SCANMAN_EVENT_DEV_REQUEST_REFUSE=101,  /* dev request refused */
    SCANMAN_EVENT_DEV_REQUEST_FAIL=102,    /* dev request accepted but failed to execute */
    /* more later */
} scanman_event_t;


/* function prototypes */
void ScanManInit(void);

scan_err_t scanman_msg_send( scan_msg_t *msg );
scan_err_t scanman_dev_request( uint32_t request, int arg, void *ptr, uint32_t *request_id );

bool scanner_is_alive( void ); 

#ifdef _PTHREAD_H
pthread_t scanman_thread_identify( void );
#endif

#ifdef EVENT_OBSERVER_H
#define SCANMAN_OBSERVER_ID 0x736d616e

typedef struct 
{
    Response_Subject_T_BaseClassMembers;
    scanman_event_t event;
    uint32_t value;
} scanman_observer_data_t;

scan_err_t scanman_obs_onetime_init( void );
scan_err_t scanman_obs_navel_gazer_init( void );

void scanman_observer_attach( Observer_t *o );
void scanman_observer_detach(Observer_t *o);
void scanman_observer_notify_event( scanman_event_t event, uint32_t value );
void scanman_observer_get_last_event( scanman_event_t *event, uint32_t *value );
#endif

#endif

