/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2010-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


/**
 * \file scands.h
 *
 * \brief Scanner Data Store. Modeled after the netsnmp_ds_*() functions
 *
 * Variables for config/control of low level Scantask behavior.
 *
 */

#ifndef SCANDS_H
#define SCANDS_H

scan_err_t scands_onetime_init( void );

void scands_debug_dump( void );

/* The get/set functions return:
 *
 *  SCANERR_NO_ENTRY      - key does not exist in table
 *  SCANERR_INVALID_PARAM - attempt to get/set key of wrong type (e.g., calling
 *                          get on a boolean value)
 *  SCANERR_NOT_PERMITTED - access scands before scands_onetime_init() called
 *  SCANERR_ALREADY       - attempt to set value that already exists
 *                          (scands_set_xxx_if_null() functions)
 */

scan_err_t scands_get_integer( const char *name, uint32_t *value );
scan_err_t scands_get_integer_with_default( const char *name, uint32_t *value, uint32_t default_value );
scan_err_t scands_set_integer( const char *name, uint32_t value );
scan_err_t scands_delete_integer( const char *name );

/* maximum length of the name in the scands_xxx() functions */
#define SCANDS_MAX_NAMELEN 32

/* davep 02-Dec-2010 ; originally the scands used integer keys. Then I added
 * string keys. Now I removed the integer keys. But some old code uses the old
 * names. These #def's are here for backwards compatibility.
 */
#define scands_get_integer_by_name    scands_get_integer
#define scands_set_integer_by_name    scands_set_integer
#define scands_delete_integer_by_name scands_delete_integer

#endif

