/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2008-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


/**
 * \file memAPI.h
 *
 * \brief Memory allocation definitions and symbols used by the scan applications.
 *
 * NOTE:
 * The core scan code uses a version of this file provided by dros, but the apps need to
 * provide the same interfaces.  We build some of the core code here in apps directory,
 * and it's not in the kernel anymore.
 *
 * The memory limiter interfaces are not currently needed in app space.
 */

#ifndef MEMAPI_H
#define MEMAPI_H

#include <stdint.h>
#include <stdbool.h>

/** Allocation memory alignment */
typedef enum {
    e_4_byte =  0x04,
    e_8_byte =  0x08,
    e_16_byte = 0x10,
    e_32_byte = 0x20
} tAlign;

void *memMallocAlign(uint32_t size, tAlign align);
void *memMalloc(uint32_t size);
void memFree(void *address);

/* Wrapper around malloc so can (eventually) add debugging stuff. For now, send
 * directly to memMalloc()
 */
#define MEM_MALLOC(sz) memMalloc(sz)

typedef struct {
    uint32_t max;
} mlimiter_t;

mlimiter_t *mlimiter_by_name( const char *name );
void mlimiter_start( mlimiter_t * );
void mlimiter_stop( mlimiter_t * );

int32_t mlimiter_available( mlimiter_t *limiter );

void mlimiter_adjust_limits( mlimiter_t *limiter, uint32_t lowest_max, uint32_t highest_max );

#define MEM_MALLOC_ALIGN(size,align) memMallocAlign(size,align)
#define MEM_MALLOC_ALIGN_LIMITED(limiter,size,align) memMallocAlign(size,align)
#define MEM_MALLOC_LIMITED(limiter,size) memMalloc(size)

#endif

