/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2007-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/


/**
 * \file lassert.h
 *
 * \brief simple reimplementation of assert()
 *
 */
/*
 * THIS IS A WORK IN PROGRESS!!!
 *
 * When the scan firmware is compiled into the BSDK BLOB (libscan-platform.a),
 * the following symbols and functions are used in the compile.  The external
 * BSDK user must create an interface using exactly these symbols.
 *
 * AssertFail
 * XAssertFail
 *
 * davep 15-Sep-2008
 */

#ifndef LASSERT_H
#  define LASSERT_H

#include <stdint.h>

typedef void (*assertfunc)(void);
extern int atassert( assertfunc f );

#  ifdef __cplusplus
      extern "C" void AssertFail(const char *, const char *, int);
      extern "C" void XAssertFail(const char *, const char *, int, uint32_t );
#  else
      extern void AssertFail(const char *, const char *, int);
      extern void XAssertFail(const char *, const char *, int, uint32_t );
#  endif
#else
#  undef ASSERT
#  undef XASSERT
#endif

#ifdef DEBUG
#  ifdef __STDC__
#    define ASSERT(e) ((e) ? (void)0 : AssertFail(#e, __FILE__, __LINE__))
#    define XASSERT(e,errvalue) ((e) ? (void)0 : XAssertFail(#e, __FILE__,__LINE__,(errvalue)))
#  else
#    define ASSERT(e) ((e) ? (void)0 : AssertFail("e", __FILE__, __LINE__))
#    define XASSERT(e,errvalue) ((e) ? (void)0 : XAssertFail("e", __FILE__,__LINE__,(errvalue)))
#  endif
#else
#  define ASSERT(ignore) ((void)0)
#  define XASSERT(ignore,errvalue) ((void)0)
#endif

