 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014-2016, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _IPS_APB_CONFIG_REGSTRUCTS_H_
#define _IPS_APB_CONFIG_REGSTRUCTS_H_

#include <stdint.h>

//====================================================================
//
//Register File: Chip configuration registers (IPS_APB_config)
/** \brief Configuration registers contained in IPS_APB_config.v*/
//
//====================================================================

typedef struct IPS_APB_CONFIG_REGS_s
{
  volatile uint32_t JBIG_REV0;  ///< 0x0 [R]: JBIG Tagging Revision 0
  volatile uint32_t JBIG_REV1;  ///< 0x4 [R]: JBIG Tagging Revision 1
  volatile uint32_t OFCR;  ///< 0x8 [R/W]: Optional Feature Control Register
  volatile uint32_t OFSR;  ///< 0xc [R]: Optional Feature Status Register
  volatile uint32_t AMC;  ///< 0x10 [R/W]: DB Mux Control
  volatile uint32_t MFC;  ///< 0x14 [R/W]: Miscellaneous Feature Control
} IPS_APB_CONFIG_REGS_t;

#endif // IPS_APB_CONFIG
