 /*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef _ICE_TEST_DMA_REGMASKS_H_
#define _ICE_TEST_DMA_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Register descriptions for ICE_test_dma module (ICE_test_dma)
/** \brief Register Descriptions for the ICE_test_dma block*/
//
//====================================================================

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  ICE_TEST_DMA_REV0_CFG_MASK 0xffff0000
#define  ICE_TEST_DMA_REV0_CFG_SHIFT 16
#define  ICE_TEST_DMA_REV0_CFG_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_REV0_CFG_MASK) >> ICE_TEST_DMA_REV0_CFG_SHIFT)
#define  ICE_TEST_DMA_REV0_CFG_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_REV0_CFG_MASK) | (((uint32_t)val) << ICE_TEST_DMA_REV0_CFG_SHIFT))

#define  ICE_TEST_DMA_REV0_MAJ_MASK 0xffff
#define  ICE_TEST_DMA_REV0_MAJ_SHIFT 0
#define  ICE_TEST_DMA_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_REV0_MAJ_MASK) >> ICE_TEST_DMA_REV0_MAJ_SHIFT)
#define  ICE_TEST_DMA_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_REV0_MAJ_MASK) | (((uint32_t)val) << ICE_TEST_DMA_REV0_MAJ_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ICE_TEST_DMA_REV1_MID_MASK 0xffff0000
#define  ICE_TEST_DMA_REV1_MID_SHIFT 16
#define  ICE_TEST_DMA_REV1_MID_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_REV1_MID_MASK) >> ICE_TEST_DMA_REV1_MID_SHIFT)
#define  ICE_TEST_DMA_REV1_MID_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_REV1_MID_MASK) | (((uint32_t)val) << ICE_TEST_DMA_REV1_MID_SHIFT))

#define  ICE_TEST_DMA_REV1_RESERVED1_MASK 0xffff
#define  ICE_TEST_DMA_REV1_RESERVED1_SHIFT 0
#define  ICE_TEST_DMA_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_REV1_RESERVED1_MASK) >> ICE_TEST_DMA_REV1_RESERVED1_SHIFT)
#define  ICE_TEST_DMA_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_REV1_RESERVED1_MASK) | (((uint32_t)val) << ICE_TEST_DMA_REV1_RESERVED1_SHIFT))

//====================================================================
//Register: ICE Test Configuration Register (TestConfig)
/** \brief ICE Test Configuration Register*/
//====================================================================

#define  ICE_TEST_DMA_TESTCONFIG_RESERVED1_MASK 0xffff0000
#define  ICE_TEST_DMA_TESTCONFIG_RESERVED1_SHIFT 16
#define  ICE_TEST_DMA_TESTCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_TESTCONFIG_RESERVED1_MASK) >> ICE_TEST_DMA_TESTCONFIG_RESERVED1_SHIFT)
#define  ICE_TEST_DMA_TESTCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_TESTCONFIG_RESERVED1_MASK) | (((uint32_t)val) << ICE_TEST_DMA_TESTCONFIG_RESERVED1_SHIFT))

#define  ICE_TEST_DMA_TESTCONFIG_PICRATE_MASK 0xff00
#define  ICE_TEST_DMA_TESTCONFIG_PICRATE_SHIFT 8
#define  ICE_TEST_DMA_TESTCONFIG_PICRATE_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_TESTCONFIG_PICRATE_MASK) >> ICE_TEST_DMA_TESTCONFIG_PICRATE_SHIFT)
#define  ICE_TEST_DMA_TESTCONFIG_PICRATE_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_TESTCONFIG_PICRATE_MASK) | (((uint32_t)val) << ICE_TEST_DMA_TESTCONFIG_PICRATE_SHIFT))

#define  ICE_TEST_DMA_TESTCONFIG_RESERVED2_MASK 0xc0
#define  ICE_TEST_DMA_TESTCONFIG_RESERVED2_SHIFT 6
#define  ICE_TEST_DMA_TESTCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_TESTCONFIG_RESERVED2_MASK) >> ICE_TEST_DMA_TESTCONFIG_RESERVED2_SHIFT)
#define  ICE_TEST_DMA_TESTCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_TESTCONFIG_RESERVED2_MASK) | (((uint32_t)val) << ICE_TEST_DMA_TESTCONFIG_RESERVED2_SHIFT))

#define  ICE_TEST_DMA_TESTCONFIG_DISABLEPACING_MASK 0x20
#define  ICE_TEST_DMA_TESTCONFIG_DISABLEPACING_SHIFT 5
#define  ICE_TEST_DMA_TESTCONFIG_DISABLEPACING_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_TESTCONFIG_DISABLEPACING_MASK) >> ICE_TEST_DMA_TESTCONFIG_DISABLEPACING_SHIFT)
#define  ICE_TEST_DMA_TESTCONFIG_DISABLEPACING_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_TESTCONFIG_DISABLEPACING_MASK) | (((uint32_t)val) << ICE_TEST_DMA_TESTCONFIG_DISABLEPACING_SHIFT))

#define  ICE_TEST_DMA_TESTCONFIG_BLANKEN_MASK 0x10
#define  ICE_TEST_DMA_TESTCONFIG_BLANKEN_SHIFT 4
#define  ICE_TEST_DMA_TESTCONFIG_BLANKEN_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_TESTCONFIG_BLANKEN_MASK) >> ICE_TEST_DMA_TESTCONFIG_BLANKEN_SHIFT)
#define  ICE_TEST_DMA_TESTCONFIG_BLANKEN_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_TESTCONFIG_BLANKEN_MASK) | (((uint32_t)val) << ICE_TEST_DMA_TESTCONFIG_BLANKEN_SHIFT))

#define  ICE_TEST_DMA_TESTCONFIG_TESTSR_MASK 0x8
#define  ICE_TEST_DMA_TESTCONFIG_TESTSR_SHIFT 3
#define  ICE_TEST_DMA_TESTCONFIG_TESTSR_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_TESTCONFIG_TESTSR_MASK) >> ICE_TEST_DMA_TESTCONFIG_TESTSR_SHIFT)
#define  ICE_TEST_DMA_TESTCONFIG_TESTSR_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_TESTCONFIG_TESTSR_MASK) | (((uint32_t)val) << ICE_TEST_DMA_TESTCONFIG_TESTSR_SHIFT))

#define  ICE_TEST_DMA_TESTCONFIG_TESTEN_MASK 0x4
#define  ICE_TEST_DMA_TESTCONFIG_TESTEN_SHIFT 2
#define  ICE_TEST_DMA_TESTCONFIG_TESTEN_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_TESTCONFIG_TESTEN_MASK) >> ICE_TEST_DMA_TESTCONFIG_TESTEN_SHIFT)
#define  ICE_TEST_DMA_TESTCONFIG_TESTEN_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_TESTCONFIG_TESTEN_MASK) | (((uint32_t)val) << ICE_TEST_DMA_TESTCONFIG_TESTEN_SHIFT))

#define  ICE_TEST_DMA_TESTCONFIG_TESTSEL_MASK 0x3
#define  ICE_TEST_DMA_TESTCONFIG_TESTSEL_SHIFT 0
#define  ICE_TEST_DMA_TESTCONFIG_TESTSEL_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_TESTCONFIG_TESTSEL_MASK) >> ICE_TEST_DMA_TESTCONFIG_TESTSEL_SHIFT)
#define  ICE_TEST_DMA_TESTCONFIG_TESTSEL_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_TESTCONFIG_TESTSEL_MASK) | (((uint32_t)val) << ICE_TEST_DMA_TESTCONFIG_TESTSEL_SHIFT))

//====================================================================
//Register: Interrupt Enable (IntEn)
/** \brief This register allows firmware to either enable or mask off the testmode underflow and overflow
        interrupts. The other interrupt source for ICE test is the IDMA block, and it's interrupt
        can be enabled or masked using the IDMA Interrupt Enable register.*/
//====================================================================

#define  ICE_TEST_DMA_INTEN_RESERVED1_MASK 0xfffffffc
#define  ICE_TEST_DMA_INTEN_RESERVED1_SHIFT 2
#define  ICE_TEST_DMA_INTEN_RESERVED1_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_INTEN_RESERVED1_MASK) >> ICE_TEST_DMA_INTEN_RESERVED1_SHIFT)
#define  ICE_TEST_DMA_INTEN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_INTEN_RESERVED1_MASK) | (((uint32_t)val) << ICE_TEST_DMA_INTEN_RESERVED1_SHIFT))

#define  ICE_TEST_DMA_INTEN_OVERFLOWINTEN_MASK 0x2
#define  ICE_TEST_DMA_INTEN_OVERFLOWINTEN_SHIFT 1
#define  ICE_TEST_DMA_INTEN_OVERFLOWINTEN_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_INTEN_OVERFLOWINTEN_MASK) >> ICE_TEST_DMA_INTEN_OVERFLOWINTEN_SHIFT)
#define  ICE_TEST_DMA_INTEN_OVERFLOWINTEN_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_INTEN_OVERFLOWINTEN_MASK) | (((uint32_t)val) << ICE_TEST_DMA_INTEN_OVERFLOWINTEN_SHIFT))

#define  ICE_TEST_DMA_INTEN_UNDERINTEN_MASK 0x1
#define  ICE_TEST_DMA_INTEN_UNDERINTEN_SHIFT 0
#define  ICE_TEST_DMA_INTEN_UNDERINTEN_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_INTEN_UNDERINTEN_MASK) >> ICE_TEST_DMA_INTEN_UNDERINTEN_SHIFT)
#define  ICE_TEST_DMA_INTEN_UNDERINTEN_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_INTEN_UNDERINTEN_MASK) | (((uint32_t)val) << ICE_TEST_DMA_INTEN_UNDERINTEN_SHIFT))

//====================================================================
//Register: Interrupt Pending (IntPend)
/** \brief This register allows firmware to determine which of the two interrupt sources within
        the ICE test block needs servicing.*/
//====================================================================

#define  ICE_TEST_DMA_INTPEND_RESERVED1_MASK 0xfffffff8
#define  ICE_TEST_DMA_INTPEND_RESERVED1_SHIFT 3
#define  ICE_TEST_DMA_INTPEND_RESERVED1_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_INTPEND_RESERVED1_MASK) >> ICE_TEST_DMA_INTPEND_RESERVED1_SHIFT)
#define  ICE_TEST_DMA_INTPEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_INTPEND_RESERVED1_MASK) | (((uint32_t)val) << ICE_TEST_DMA_INTPEND_RESERVED1_SHIFT))
//////////////////////////////////////////////////////////
// MULTIPLE CHOICES FOR INTERRUPTS FOR REVA/REVB PEND REG
//////////////////////////////////////////////////////////
#define  ICE_TEST_DMA_INTPEND_OVERINTPEND_MASK_REVA 0x4
#define  ICE_TEST_DMA_INTPEND_OVERINTPEND_SHIFT_REVA 2
#define  ICE_TEST_DMA_INTPEND_OVERINTPEND_MASK_SHIFT_REVA(reg) (((reg) & ICE_TEST_DMA_INTPEND_OVERINTPEND_MASK_REVA) >> ICE_TEST_DMA_INTPEND_OVERINTPEND_SHIFT_REVA)
#define  ICE_TEST_DMA_INTPEND_OVERINTPEND_REPLACE_VAL_REVA(reg,val) (((reg) & ~ICE_TEST_DMA_INTPEND_OVERINTPEND_MASK_REVA) | (((uint32_t)val) << ICE_TEST_DMA_INTPEND_OVERINTPEND_SHIFT_REVA))

#define  ICE_TEST_DMA_INTPEND_DMAINTPEND_MASK_REVA 0x2
#define  ICE_TEST_DMA_INTPEND_DMAINTPEND_SHIFT_REVA 1
#define  ICE_TEST_DMA_INTPEND_DMAINTPEND_MASK_SHIFT_REVA(reg) (((reg) & ICE_TEST_DMA_INTPEND_DMAINTPEND_MASK_REVA) >> ICE_TEST_DMA_INTPEND_DMAINTPEND_SHIFT_REVA)
#define  ICE_TEST_DMA_INTPEND_DMAINTPEND_REPLACE_VAL_REVA(reg,val) (((reg) & ~ICE_TEST_DMA_INTPEND_DMAINTPEND_MASK_REVA) | (((uint32_t)val) << ICE_TEST_DMA_INTPEND_DMAINTPEND_SHIFT_REVA))

//////////////////////////////////////////////
// FOR REVB and later
//////////////////////////////////////////////
#define  ICE_TEST_DMA_INTPEND_OVERINTPEND_MASK 0x2
#define  ICE_TEST_DMA_INTPEND_OVERINTPEND_SHIFT 1
#define  ICE_TEST_DMA_INTPEND_OVERINTPEND_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_INTPEND_OVERINTPEND_MASK) >> ICE_TEST_DMA_INTPEND_OVERINTPEND_SHIFT)
#define  ICE_TEST_DMA_INTPEND_OVERINTPEND_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_INTPEND_OVERINTPEND_MASK) | (((uint32_t)val) << ICE_TEST_DMA_INTPEND_OVERINTPEND_SHIFT))

#define  ICE_TEST_DMA_INTPEND_DMAINTPEND_MASK 0x4
#define  ICE_TEST_DMA_INTPEND_DMAINTPEND_SHIFT 2
#define  ICE_TEST_DMA_INTPEND_DMAINTPEND_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_INTPEND_DMAINTPEND_MASK) >> ICE_TEST_DMA_INTPEND_DMAINTPEND_SHIFT)
#define  ICE_TEST_DMA_INTPEND_DMAINTPEND_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_INTPEND_DMAINTPEND_MASK) | (((uint32_t)val) << ICE_TEST_DMA_INTPEND_DMAINTPEND_SHIFT))

//////////////////////////////////////////////
// END of REVA/REVB for icetest dma interrupts
//////////////////////////////////////////////

#define  ICE_TEST_DMA_INTPEND_UNDERINTPEND_MASK 0x1
#define  ICE_TEST_DMA_INTPEND_UNDERINTPEND_SHIFT 0
#define  ICE_TEST_DMA_INTPEND_UNDERINTPEND_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_INTPEND_UNDERINTPEND_MASK) >> ICE_TEST_DMA_INTPEND_UNDERINTPEND_SHIFT)
#define  ICE_TEST_DMA_INTPEND_UNDERINTPEND_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_INTPEND_UNDERINTPEND_MASK) | (((uint32_t)val) << ICE_TEST_DMA_INTPEND_UNDERINTPEND_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge (IntAck)
/** \brief This register allows firmware to acknowledge (clear) the ICE test underflow interrupt.
        Note that the IDMA interrupt is cleared using the IDMA interrupt acknowledge register.*/
//====================================================================

#define  ICE_TEST_DMA_INTACK_RESERVED1_MASK 0xfffffffc
#define  ICE_TEST_DMA_INTACK_RESERVED1_SHIFT 2
#define  ICE_TEST_DMA_INTACK_RESERVED1_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_INTACK_RESERVED1_MASK) >> ICE_TEST_DMA_INTACK_RESERVED1_SHIFT)
#define  ICE_TEST_DMA_INTACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_INTACK_RESERVED1_MASK) | (((uint32_t)val) << ICE_TEST_DMA_INTACK_RESERVED1_SHIFT))

#define  ICE_TEST_DMA_INTACK_OVERFLOWINTACK_MASK 0x2
#define  ICE_TEST_DMA_INTACK_OVERFLOWINTACK_SHIFT 1
#define  ICE_TEST_DMA_INTACK_OVERFLOWINTACK_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_INTACK_OVERFLOWINTACK_MASK) >> ICE_TEST_DMA_INTACK_OVERFLOWINTACK_SHIFT)
#define  ICE_TEST_DMA_INTACK_OVERFLOWINTACK_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_INTACK_OVERFLOWINTACK_MASK) | (((uint32_t)val) << ICE_TEST_DMA_INTACK_OVERFLOWINTACK_SHIFT))

#define  ICE_TEST_DMA_INTACK_UNDERINTACK_MASK 0x1
#define  ICE_TEST_DMA_INTACK_UNDERINTACK_SHIFT 0
#define  ICE_TEST_DMA_INTACK_UNDERINTACK_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_INTACK_UNDERINTACK_MASK) >> ICE_TEST_DMA_INTACK_UNDERINTACK_SHIFT)
#define  ICE_TEST_DMA_INTACK_UNDERINTACK_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_INTACK_UNDERINTACK_MASK) | (((uint32_t)val) << ICE_TEST_DMA_INTACK_UNDERINTACK_SHIFT))

//====================================================================
//Register: Interrupt Force (IntForce)
/** \brief This register allows firmware to set the ICE test overflow and underflow interrupts.
        Note that the IDMA interrupt sources can be forced using the IDMA interrupt force register.*/
//====================================================================

#define  ICE_TEST_DMA_INTFORCE_RESERVED1_MASK 0xfffffffc
#define  ICE_TEST_DMA_INTFORCE_RESERVED1_SHIFT 2
#define  ICE_TEST_DMA_INTFORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_INTFORCE_RESERVED1_MASK) >> ICE_TEST_DMA_INTFORCE_RESERVED1_SHIFT)
#define  ICE_TEST_DMA_INTFORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_INTFORCE_RESERVED1_MASK) | (((uint32_t)val) << ICE_TEST_DMA_INTFORCE_RESERVED1_SHIFT))

#define  ICE_TEST_DMA_INTFORCE_OVERFLOWINTFORCE_MASK 0x2
#define  ICE_TEST_DMA_INTFORCE_OVERFLOWINTFORCE_SHIFT 1
#define  ICE_TEST_DMA_INTFORCE_OVERFLOWINTFORCE_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_INTFORCE_OVERFLOWINTFORCE_MASK) >> ICE_TEST_DMA_INTFORCE_OVERFLOWINTFORCE_SHIFT)
#define  ICE_TEST_DMA_INTFORCE_OVERFLOWINTFORCE_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_INTFORCE_OVERFLOWINTFORCE_MASK) | (((uint32_t)val) << ICE_TEST_DMA_INTFORCE_OVERFLOWINTFORCE_SHIFT))

#define  ICE_TEST_DMA_INTFORCE_UNDERINTFORCE_MASK 0x1
#define  ICE_TEST_DMA_INTFORCE_UNDERINTFORCE_SHIFT 0
#define  ICE_TEST_DMA_INTFORCE_UNDERINTFORCE_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_INTFORCE_UNDERINTFORCE_MASK) >> ICE_TEST_DMA_INTFORCE_UNDERINTFORCE_SHIFT)
#define  ICE_TEST_DMA_INTFORCE_UNDERINTFORCE_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_INTFORCE_UNDERINTFORCE_MASK) | (((uint32_t)val) << ICE_TEST_DMA_INTFORCE_UNDERINTFORCE_SHIFT))

//====================================================================
//Register: End of Line Blanking Region (EOLBlank)
/** \brief This register allows firmware to set a blank region after each line of pixel data. This is intended
        to better represent the flow of data from a scanner. The eolWidth determines how long
        the blanking region between lines is. The eolPixCnt tells the logic how many pixels are in each scan line.*/
//====================================================================

#define  ICE_TEST_DMA_EOLBLANK_EOLPIXCNT_MASK 0xffff0000
#define  ICE_TEST_DMA_EOLBLANK_EOLPIXCNT_SHIFT 16
#define  ICE_TEST_DMA_EOLBLANK_EOLPIXCNT_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_EOLBLANK_EOLPIXCNT_MASK) >> ICE_TEST_DMA_EOLBLANK_EOLPIXCNT_SHIFT)
#define  ICE_TEST_DMA_EOLBLANK_EOLPIXCNT_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_EOLBLANK_EOLPIXCNT_MASK) | (((uint32_t)val) << ICE_TEST_DMA_EOLBLANK_EOLPIXCNT_SHIFT))

#define  ICE_TEST_DMA_EOLBLANK_EOLWIDTH_MASK 0xffff
#define  ICE_TEST_DMA_EOLBLANK_EOLWIDTH_SHIFT 0
#define  ICE_TEST_DMA_EOLBLANK_EOLWIDTH_MASK_SHIFT(reg) (((reg) & ICE_TEST_DMA_EOLBLANK_EOLWIDTH_MASK) >> ICE_TEST_DMA_EOLBLANK_EOLWIDTH_SHIFT)
#define  ICE_TEST_DMA_EOLBLANK_EOLWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ICE_TEST_DMA_EOLBLANK_EOLWIDTH_MASK) | (((uint32_t)val) << ICE_TEST_DMA_EOLBLANK_EOLWIDTH_SHIFT))

//====================================================================
//
//Register File: ICE Test DMA register set (TestIDMA)
/** \brief Registers for the IDMA_AXI module <br/> (rev 0 . 1 . 0 . 1)*/
//
//====================================================================

//====================================================================
//Register: Configuration register (cfg)
//====================================================================

#define  TESTIDMA_CFG_RESERVED1_MASK 0xfe000000
#define  TESTIDMA_CFG_RESERVED1_SHIFT 25
#define  TESTIDMA_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & TESTIDMA_CFG_RESERVED1_MASK) >> TESTIDMA_CFG_RESERVED1_SHIFT)
#define  TESTIDMA_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_CFG_RESERVED1_MASK) | (((uint32_t)val) << TESTIDMA_CFG_RESERVED1_SHIFT))

#define  TESTIDMA_CFG_REPLICATE_MASK 0x1000000
#define  TESTIDMA_CFG_REPLICATE_SHIFT 24
#define  TESTIDMA_CFG_REPLICATE_MASK_SHIFT(reg) (((reg) & TESTIDMA_CFG_REPLICATE_MASK) >> TESTIDMA_CFG_REPLICATE_SHIFT)
#define  TESTIDMA_CFG_REPLICATE_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_CFG_REPLICATE_MASK) | (((uint32_t)val) << TESTIDMA_CFG_REPLICATE_SHIFT))

#define  TESTIDMA_CFG_RESERVED2_MASK 0xfe0000
#define  TESTIDMA_CFG_RESERVED2_SHIFT 17
#define  TESTIDMA_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & TESTIDMA_CFG_RESERVED2_MASK) >> TESTIDMA_CFG_RESERVED2_SHIFT)
#define  TESTIDMA_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_CFG_RESERVED2_MASK) | (((uint32_t)val) << TESTIDMA_CFG_RESERVED2_SHIFT))

#define  TESTIDMA_CFG_ENABLE_MASK 0x10000
#define  TESTIDMA_CFG_ENABLE_SHIFT 16
#define  TESTIDMA_CFG_ENABLE_MASK_SHIFT(reg) (((reg) & TESTIDMA_CFG_ENABLE_MASK) >> TESTIDMA_CFG_ENABLE_SHIFT)
#define  TESTIDMA_CFG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_CFG_ENABLE_MASK) | (((uint32_t)val) << TESTIDMA_CFG_ENABLE_SHIFT))

#define  TESTIDMA_CFG_RESERVED3_MASK 0xf800
#define  TESTIDMA_CFG_RESERVED3_SHIFT 11
#define  TESTIDMA_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & TESTIDMA_CFG_RESERVED3_MASK) >> TESTIDMA_CFG_RESERVED3_SHIFT)
#define  TESTIDMA_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_CFG_RESERVED3_MASK) | (((uint32_t)val) << TESTIDMA_CFG_RESERVED3_SHIFT))

#define  TESTIDMA_CFG_OUT_WIDTH_MASK 0x700
#define  TESTIDMA_CFG_OUT_WIDTH_SHIFT 8
#define  TESTIDMA_CFG_OUT_WIDTH_MASK_SHIFT(reg) (((reg) & TESTIDMA_CFG_OUT_WIDTH_MASK) >> TESTIDMA_CFG_OUT_WIDTH_SHIFT)
#define  TESTIDMA_CFG_OUT_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_CFG_OUT_WIDTH_MASK) | (((uint32_t)val) << TESTIDMA_CFG_OUT_WIDTH_SHIFT))

#define  TESTIDMA_CFG_RESERVED4_MASK 0xe0
#define  TESTIDMA_CFG_RESERVED4_SHIFT 5
#define  TESTIDMA_CFG_RESERVED4_MASK_SHIFT(reg) (((reg) & TESTIDMA_CFG_RESERVED4_MASK) >> TESTIDMA_CFG_RESERVED4_SHIFT)
#define  TESTIDMA_CFG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_CFG_RESERVED4_MASK) | (((uint32_t)val) << TESTIDMA_CFG_RESERVED4_SHIFT))

#define  TESTIDMA_CFG_HANDSHAKEENABLE_MASK 0x10
#define  TESTIDMA_CFG_HANDSHAKEENABLE_SHIFT 4
#define  TESTIDMA_CFG_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & TESTIDMA_CFG_HANDSHAKEENABLE_MASK) >> TESTIDMA_CFG_HANDSHAKEENABLE_SHIFT)
#define  TESTIDMA_CFG_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_CFG_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << TESTIDMA_CFG_HANDSHAKEENABLE_SHIFT))

#define  TESTIDMA_CFG_OWNWRITEDISABLE_MASK 0x8
#define  TESTIDMA_CFG_OWNWRITEDISABLE_SHIFT 3
#define  TESTIDMA_CFG_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & TESTIDMA_CFG_OWNWRITEDISABLE_MASK) >> TESTIDMA_CFG_OWNWRITEDISABLE_SHIFT)
#define  TESTIDMA_CFG_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_CFG_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << TESTIDMA_CFG_OWNWRITEDISABLE_SHIFT))

#define  TESTIDMA_CFG_OWNPOLARITY_MASK 0x4
#define  TESTIDMA_CFG_OWNPOLARITY_SHIFT 2
#define  TESTIDMA_CFG_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & TESTIDMA_CFG_OWNPOLARITY_MASK) >> TESTIDMA_CFG_OWNPOLARITY_SHIFT)
#define  TESTIDMA_CFG_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_CFG_OWNPOLARITY_MASK) | (((uint32_t)val) << TESTIDMA_CFG_OWNPOLARITY_SHIFT))

#define  TESTIDMA_CFG_BURST_LEN_MASK 0x3
#define  TESTIDMA_CFG_BURST_LEN_SHIFT 0
#define  TESTIDMA_CFG_BURST_LEN_MASK_SHIFT(reg) (((reg) & TESTIDMA_CFG_BURST_LEN_MASK) >> TESTIDMA_CFG_BURST_LEN_SHIFT)
#define  TESTIDMA_CFG_BURST_LEN_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_CFG_BURST_LEN_MASK) | (((uint32_t)val) << TESTIDMA_CFG_BURST_LEN_SHIFT))

//====================================================================
//Register: Status register (status)
//====================================================================

#define  TESTIDMA_STATUS_RESERVED1_MASK 0xfffff000
#define  TESTIDMA_STATUS_RESERVED1_SHIFT 12
#define  TESTIDMA_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & TESTIDMA_STATUS_RESERVED1_MASK) >> TESTIDMA_STATUS_RESERVED1_SHIFT)
#define  TESTIDMA_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_STATUS_RESERVED1_MASK) | (((uint32_t)val) << TESTIDMA_STATUS_RESERVED1_SHIFT))

#define  TESTIDMA_STATUS_DMAPAUSED_MASK 0x800
#define  TESTIDMA_STATUS_DMAPAUSED_SHIFT 11
#define  TESTIDMA_STATUS_DMAPAUSED_MASK_SHIFT(reg) (((reg) & TESTIDMA_STATUS_DMAPAUSED_MASK) >> TESTIDMA_STATUS_DMAPAUSED_SHIFT)
#define  TESTIDMA_STATUS_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_STATUS_DMAPAUSED_MASK) | (((uint32_t)val) << TESTIDMA_STATUS_DMAPAUSED_SHIFT))

#define  TESTIDMA_STATUS_PAUSEAFTER_MASK 0x400
#define  TESTIDMA_STATUS_PAUSEAFTER_SHIFT 10
#define  TESTIDMA_STATUS_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & TESTIDMA_STATUS_PAUSEAFTER_MASK) >> TESTIDMA_STATUS_PAUSEAFTER_SHIFT)
#define  TESTIDMA_STATUS_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_STATUS_PAUSEAFTER_MASK) | (((uint32_t)val) << TESTIDMA_STATUS_PAUSEAFTER_SHIFT))

#define  TESTIDMA_STATUS_PAUSEBEFORE_MASK 0x200
#define  TESTIDMA_STATUS_PAUSEBEFORE_SHIFT 9
#define  TESTIDMA_STATUS_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & TESTIDMA_STATUS_PAUSEBEFORE_MASK) >> TESTIDMA_STATUS_PAUSEBEFORE_SHIFT)
#define  TESTIDMA_STATUS_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_STATUS_PAUSEBEFORE_MASK) | (((uint32_t)val) << TESTIDMA_STATUS_PAUSEBEFORE_SHIFT))

#define  TESTIDMA_STATUS_SOI_MASK 0x100
#define  TESTIDMA_STATUS_SOI_SHIFT 8
#define  TESTIDMA_STATUS_SOI_MASK_SHIFT(reg) (((reg) & TESTIDMA_STATUS_SOI_MASK) >> TESTIDMA_STATUS_SOI_SHIFT)
#define  TESTIDMA_STATUS_SOI_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_STATUS_SOI_MASK) | (((uint32_t)val) << TESTIDMA_STATUS_SOI_SHIFT))

#define  TESTIDMA_STATUS_EOI_MASK 0x80
#define  TESTIDMA_STATUS_EOI_SHIFT 7
#define  TESTIDMA_STATUS_EOI_MASK_SHIFT(reg) (((reg) & TESTIDMA_STATUS_EOI_MASK) >> TESTIDMA_STATUS_EOI_SHIFT)
#define  TESTIDMA_STATUS_EOI_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_STATUS_EOI_MASK) | (((uint32_t)val) << TESTIDMA_STATUS_EOI_SHIFT))

#define  TESTIDMA_STATUS_SOFTRESET_MASK 0x40
#define  TESTIDMA_STATUS_SOFTRESET_SHIFT 6
#define  TESTIDMA_STATUS_SOFTRESET_MASK_SHIFT(reg) (((reg) & TESTIDMA_STATUS_SOFTRESET_MASK) >> TESTIDMA_STATUS_SOFTRESET_SHIFT)
#define  TESTIDMA_STATUS_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_STATUS_SOFTRESET_MASK) | (((uint32_t)val) << TESTIDMA_STATUS_SOFTRESET_SHIFT))

#define  TESTIDMA_STATUS_FULL_CBUF_MASK 0x20
#define  TESTIDMA_STATUS_FULL_CBUF_SHIFT 5
#define  TESTIDMA_STATUS_FULL_CBUF_MASK_SHIFT(reg) (((reg) & TESTIDMA_STATUS_FULL_CBUF_MASK) >> TESTIDMA_STATUS_FULL_CBUF_SHIFT)
#define  TESTIDMA_STATUS_FULL_CBUF_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_STATUS_FULL_CBUF_MASK) | (((uint32_t)val) << TESTIDMA_STATUS_FULL_CBUF_SHIFT))

#define  TESTIDMA_STATUS_EMPTY_CBUF_MASK 0x10
#define  TESTIDMA_STATUS_EMPTY_CBUF_SHIFT 4
#define  TESTIDMA_STATUS_EMPTY_CBUF_MASK_SHIFT(reg) (((reg) & TESTIDMA_STATUS_EMPTY_CBUF_MASK) >> TESTIDMA_STATUS_EMPTY_CBUF_SHIFT)
#define  TESTIDMA_STATUS_EMPTY_CBUF_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_STATUS_EMPTY_CBUF_MASK) | (((uint32_t)val) << TESTIDMA_STATUS_EMPTY_CBUF_SHIFT))

#define  TESTIDMA_STATUS_FULL_DBUF_MASK 0x8
#define  TESTIDMA_STATUS_FULL_DBUF_SHIFT 3
#define  TESTIDMA_STATUS_FULL_DBUF_MASK_SHIFT(reg) (((reg) & TESTIDMA_STATUS_FULL_DBUF_MASK) >> TESTIDMA_STATUS_FULL_DBUF_SHIFT)
#define  TESTIDMA_STATUS_FULL_DBUF_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_STATUS_FULL_DBUF_MASK) | (((uint32_t)val) << TESTIDMA_STATUS_FULL_DBUF_SHIFT))

#define  TESTIDMA_STATUS_EMPTY_DBUF_MASK 0x4
#define  TESTIDMA_STATUS_EMPTY_DBUF_SHIFT 2
#define  TESTIDMA_STATUS_EMPTY_DBUF_MASK_SHIFT(reg) (((reg) & TESTIDMA_STATUS_EMPTY_DBUF_MASK) >> TESTIDMA_STATUS_EMPTY_DBUF_SHIFT)
#define  TESTIDMA_STATUS_EMPTY_DBUF_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_STATUS_EMPTY_DBUF_MASK) | (((uint32_t)val) << TESTIDMA_STATUS_EMPTY_DBUF_SHIFT))

#define  TESTIDMA_STATUS_PACKER_EMPTY_MASK 0x2
#define  TESTIDMA_STATUS_PACKER_EMPTY_SHIFT 1
#define  TESTIDMA_STATUS_PACKER_EMPTY_MASK_SHIFT(reg) (((reg) & TESTIDMA_STATUS_PACKER_EMPTY_MASK) >> TESTIDMA_STATUS_PACKER_EMPTY_SHIFT)
#define  TESTIDMA_STATUS_PACKER_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_STATUS_PACKER_EMPTY_MASK) | (((uint32_t)val) << TESTIDMA_STATUS_PACKER_EMPTY_SHIFT))

#define  TESTIDMA_STATUS_DMA_BUSY_MASK 0x1
#define  TESTIDMA_STATUS_DMA_BUSY_SHIFT 0
#define  TESTIDMA_STATUS_DMA_BUSY_MASK_SHIFT(reg) (((reg) & TESTIDMA_STATUS_DMA_BUSY_MASK) >> TESTIDMA_STATUS_DMA_BUSY_SHIFT)
#define  TESTIDMA_STATUS_DMA_BUSY_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_STATUS_DMA_BUSY_MASK) | (((uint32_t)val) << TESTIDMA_STATUS_DMA_BUSY_SHIFT))

//====================================================================
//Register: Line Width register (line_width)
//====================================================================

#define  TESTIDMA_LINE_WIDTH_RESERVED1_MASK 0xffff0000
#define  TESTIDMA_LINE_WIDTH_RESERVED1_SHIFT 16
#define  TESTIDMA_LINE_WIDTH_RESERVED1_MASK_SHIFT(reg) (((reg) & TESTIDMA_LINE_WIDTH_RESERVED1_MASK) >> TESTIDMA_LINE_WIDTH_RESERVED1_SHIFT)
#define  TESTIDMA_LINE_WIDTH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_LINE_WIDTH_RESERVED1_MASK) | (((uint32_t)val) << TESTIDMA_LINE_WIDTH_RESERVED1_SHIFT))

#define  TESTIDMA_LINE_WIDTH_LINE_WIDTH_MASK 0xffff
#define  TESTIDMA_LINE_WIDTH_LINE_WIDTH_SHIFT 0
#define  TESTIDMA_LINE_WIDTH_LINE_WIDTH_MASK_SHIFT(reg) (((reg) & TESTIDMA_LINE_WIDTH_LINE_WIDTH_MASK) >> TESTIDMA_LINE_WIDTH_LINE_WIDTH_SHIFT)
#define  TESTIDMA_LINE_WIDTH_LINE_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_LINE_WIDTH_LINE_WIDTH_MASK) | (((uint32_t)val) << TESTIDMA_LINE_WIDTH_LINE_WIDTH_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (int_en)
//====================================================================

#define  TESTIDMA_INT_EN_RESERVED1_MASK 0xffffffc0
#define  TESTIDMA_INT_EN_RESERVED1_SHIFT 6
#define  TESTIDMA_INT_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_EN_RESERVED1_MASK) >> TESTIDMA_INT_EN_RESERVED1_SHIFT)
#define  TESTIDMA_INT_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_EN_RESERVED1_MASK) | (((uint32_t)val) << TESTIDMA_INT_EN_RESERVED1_SHIFT))

#define  TESTIDMA_INT_EN_RRESP_INT_EN_MASK 0x20
#define  TESTIDMA_INT_EN_RRESP_INT_EN_SHIFT 5
#define  TESTIDMA_INT_EN_RRESP_INT_EN_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_EN_RRESP_INT_EN_MASK) >> TESTIDMA_INT_EN_RRESP_INT_EN_SHIFT)
#define  TESTIDMA_INT_EN_RRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_EN_RRESP_INT_EN_MASK) | (((uint32_t)val) << TESTIDMA_INT_EN_RRESP_INT_EN_SHIFT))

#define  TESTIDMA_INT_EN_BRESP_INT_EN_MASK 0x10
#define  TESTIDMA_INT_EN_BRESP_INT_EN_SHIFT 4
#define  TESTIDMA_INT_EN_BRESP_INT_EN_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_EN_BRESP_INT_EN_MASK) >> TESTIDMA_INT_EN_BRESP_INT_EN_SHIFT)
#define  TESTIDMA_INT_EN_BRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_EN_BRESP_INT_EN_MASK) | (((uint32_t)val) << TESTIDMA_INT_EN_BRESP_INT_EN_SHIFT))

#define  TESTIDMA_INT_EN_RST_INT_EN_MASK 0x8
#define  TESTIDMA_INT_EN_RST_INT_EN_SHIFT 3
#define  TESTIDMA_INT_EN_RST_INT_EN_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_EN_RST_INT_EN_MASK) >> TESTIDMA_INT_EN_RST_INT_EN_SHIFT)
#define  TESTIDMA_INT_EN_RST_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_EN_RST_INT_EN_MASK) | (((uint32_t)val) << TESTIDMA_INT_EN_RST_INT_EN_SHIFT))

#define  TESTIDMA_INT_EN_EOI_INT_EN_MASK 0x4
#define  TESTIDMA_INT_EN_EOI_INT_EN_SHIFT 2
#define  TESTIDMA_INT_EN_EOI_INT_EN_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_EN_EOI_INT_EN_MASK) >> TESTIDMA_INT_EN_EOI_INT_EN_SHIFT)
#define  TESTIDMA_INT_EN_EOI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_EN_EOI_INT_EN_MASK) | (((uint32_t)val) << TESTIDMA_INT_EN_EOI_INT_EN_SHIFT))

#define  TESTIDMA_INT_EN_FIN_INT_EN_MASK 0x2
#define  TESTIDMA_INT_EN_FIN_INT_EN_SHIFT 1
#define  TESTIDMA_INT_EN_FIN_INT_EN_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_EN_FIN_INT_EN_MASK) >> TESTIDMA_INT_EN_FIN_INT_EN_SHIFT)
#define  TESTIDMA_INT_EN_FIN_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_EN_FIN_INT_EN_MASK) | (((uint32_t)val) << TESTIDMA_INT_EN_FIN_INT_EN_SHIFT))

#define  TESTIDMA_INT_EN_WHO_INT_EN_MASK 0x1
#define  TESTIDMA_INT_EN_WHO_INT_EN_SHIFT 0
#define  TESTIDMA_INT_EN_WHO_INT_EN_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_EN_WHO_INT_EN_MASK) >> TESTIDMA_INT_EN_WHO_INT_EN_SHIFT)
#define  TESTIDMA_INT_EN_WHO_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_EN_WHO_INT_EN_MASK) | (((uint32_t)val) << TESTIDMA_INT_EN_WHO_INT_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (int_st)
//====================================================================

#define  TESTIDMA_INT_ST_RESERVED1_MASK 0xffffffc0
#define  TESTIDMA_INT_ST_RESERVED1_SHIFT 6
#define  TESTIDMA_INT_ST_RESERVED1_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_ST_RESERVED1_MASK) >> TESTIDMA_INT_ST_RESERVED1_SHIFT)
#define  TESTIDMA_INT_ST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_ST_RESERVED1_MASK) | (((uint32_t)val) << TESTIDMA_INT_ST_RESERVED1_SHIFT))

#define  TESTIDMA_INT_ST_RRESP_INT_ST_MASK 0x20
#define  TESTIDMA_INT_ST_RRESP_INT_ST_SHIFT 5
#define  TESTIDMA_INT_ST_RRESP_INT_ST_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_ST_RRESP_INT_ST_MASK) >> TESTIDMA_INT_ST_RRESP_INT_ST_SHIFT)
#define  TESTIDMA_INT_ST_RRESP_INT_ST_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_ST_RRESP_INT_ST_MASK) | (((uint32_t)val) << TESTIDMA_INT_ST_RRESP_INT_ST_SHIFT))

#define  TESTIDMA_INT_ST_BRESP_INT_ST_MASK 0x10
#define  TESTIDMA_INT_ST_BRESP_INT_ST_SHIFT 4
#define  TESTIDMA_INT_ST_BRESP_INT_ST_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_ST_BRESP_INT_ST_MASK) >> TESTIDMA_INT_ST_BRESP_INT_ST_SHIFT)
#define  TESTIDMA_INT_ST_BRESP_INT_ST_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_ST_BRESP_INT_ST_MASK) | (((uint32_t)val) << TESTIDMA_INT_ST_BRESP_INT_ST_SHIFT))

#define  TESTIDMA_INT_ST_RST_INT_ST_MASK 0x8
#define  TESTIDMA_INT_ST_RST_INT_ST_SHIFT 3
#define  TESTIDMA_INT_ST_RST_INT_ST_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_ST_RST_INT_ST_MASK) >> TESTIDMA_INT_ST_RST_INT_ST_SHIFT)
#define  TESTIDMA_INT_ST_RST_INT_ST_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_ST_RST_INT_ST_MASK) | (((uint32_t)val) << TESTIDMA_INT_ST_RST_INT_ST_SHIFT))

#define  TESTIDMA_INT_ST_EOI_INT_ST_MASK 0x4
#define  TESTIDMA_INT_ST_EOI_INT_ST_SHIFT 2
#define  TESTIDMA_INT_ST_EOI_INT_ST_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_ST_EOI_INT_ST_MASK) >> TESTIDMA_INT_ST_EOI_INT_ST_SHIFT)
#define  TESTIDMA_INT_ST_EOI_INT_ST_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_ST_EOI_INT_ST_MASK) | (((uint32_t)val) << TESTIDMA_INT_ST_EOI_INT_ST_SHIFT))

#define  TESTIDMA_INT_ST_FIN_INT_ST_MASK 0x2
#define  TESTIDMA_INT_ST_FIN_INT_ST_SHIFT 1
#define  TESTIDMA_INT_ST_FIN_INT_ST_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_ST_FIN_INT_ST_MASK) >> TESTIDMA_INT_ST_FIN_INT_ST_SHIFT)
#define  TESTIDMA_INT_ST_FIN_INT_ST_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_ST_FIN_INT_ST_MASK) | (((uint32_t)val) << TESTIDMA_INT_ST_FIN_INT_ST_SHIFT))

#define  TESTIDMA_INT_ST_WHO_INT_ST_MASK 0x1
#define  TESTIDMA_INT_ST_WHO_INT_ST_SHIFT 0
#define  TESTIDMA_INT_ST_WHO_INT_ST_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_ST_WHO_INT_ST_MASK) >> TESTIDMA_INT_ST_WHO_INT_ST_SHIFT)
#define  TESTIDMA_INT_ST_WHO_INT_ST_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_ST_WHO_INT_ST_MASK) | (((uint32_t)val) << TESTIDMA_INT_ST_WHO_INT_ST_SHIFT))

//====================================================================
//Register: Interrupt Clear Register (int_cl)
//====================================================================

#define  TESTIDMA_INT_CL_RESERVED1_MASK 0xffffffc0
#define  TESTIDMA_INT_CL_RESERVED1_SHIFT 6
#define  TESTIDMA_INT_CL_RESERVED1_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_CL_RESERVED1_MASK) >> TESTIDMA_INT_CL_RESERVED1_SHIFT)
#define  TESTIDMA_INT_CL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_CL_RESERVED1_MASK) | (((uint32_t)val) << TESTIDMA_INT_CL_RESERVED1_SHIFT))

#define  TESTIDMA_INT_CL_RRESP_INT_CL_MASK 0x20
#define  TESTIDMA_INT_CL_RRESP_INT_CL_SHIFT 5
#define  TESTIDMA_INT_CL_RRESP_INT_CL_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_CL_RRESP_INT_CL_MASK) >> TESTIDMA_INT_CL_RRESP_INT_CL_SHIFT)
#define  TESTIDMA_INT_CL_RRESP_INT_CL_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_CL_RRESP_INT_CL_MASK) | (((uint32_t)val) << TESTIDMA_INT_CL_RRESP_INT_CL_SHIFT))

#define  TESTIDMA_INT_CL_BRESP_INT_CL_MASK 0x10
#define  TESTIDMA_INT_CL_BRESP_INT_CL_SHIFT 4
#define  TESTIDMA_INT_CL_BRESP_INT_CL_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_CL_BRESP_INT_CL_MASK) >> TESTIDMA_INT_CL_BRESP_INT_CL_SHIFT)
#define  TESTIDMA_INT_CL_BRESP_INT_CL_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_CL_BRESP_INT_CL_MASK) | (((uint32_t)val) << TESTIDMA_INT_CL_BRESP_INT_CL_SHIFT))

#define  TESTIDMA_INT_CL_RST_INT_CL_MASK 0x8
#define  TESTIDMA_INT_CL_RST_INT_CL_SHIFT 3
#define  TESTIDMA_INT_CL_RST_INT_CL_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_CL_RST_INT_CL_MASK) >> TESTIDMA_INT_CL_RST_INT_CL_SHIFT)
#define  TESTIDMA_INT_CL_RST_INT_CL_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_CL_RST_INT_CL_MASK) | (((uint32_t)val) << TESTIDMA_INT_CL_RST_INT_CL_SHIFT))

#define  TESTIDMA_INT_CL_EOI_INT_CL_MASK 0x4
#define  TESTIDMA_INT_CL_EOI_INT_CL_SHIFT 2
#define  TESTIDMA_INT_CL_EOI_INT_CL_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_CL_EOI_INT_CL_MASK) >> TESTIDMA_INT_CL_EOI_INT_CL_SHIFT)
#define  TESTIDMA_INT_CL_EOI_INT_CL_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_CL_EOI_INT_CL_MASK) | (((uint32_t)val) << TESTIDMA_INT_CL_EOI_INT_CL_SHIFT))

#define  TESTIDMA_INT_CL_FIN_INT_CL_MASK 0x2
#define  TESTIDMA_INT_CL_FIN_INT_CL_SHIFT 1
#define  TESTIDMA_INT_CL_FIN_INT_CL_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_CL_FIN_INT_CL_MASK) >> TESTIDMA_INT_CL_FIN_INT_CL_SHIFT)
#define  TESTIDMA_INT_CL_FIN_INT_CL_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_CL_FIN_INT_CL_MASK) | (((uint32_t)val) << TESTIDMA_INT_CL_FIN_INT_CL_SHIFT))

#define  TESTIDMA_INT_CL_WHO_INT_CL_MASK 0x1
#define  TESTIDMA_INT_CL_WHO_INT_CL_SHIFT 0
#define  TESTIDMA_INT_CL_WHO_INT_CL_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_CL_WHO_INT_CL_MASK) >> TESTIDMA_INT_CL_WHO_INT_CL_SHIFT)
#define  TESTIDMA_INT_CL_WHO_INT_CL_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_CL_WHO_INT_CL_MASK) | (((uint32_t)val) << TESTIDMA_INT_CL_WHO_INT_CL_SHIFT))

//====================================================================
//Register: Interrupt Force Register (int_fo)
//====================================================================

#define  TESTIDMA_INT_FO_RESERVED1_MASK 0xffffffc0
#define  TESTIDMA_INT_FO_RESERVED1_SHIFT 6
#define  TESTIDMA_INT_FO_RESERVED1_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_FO_RESERVED1_MASK) >> TESTIDMA_INT_FO_RESERVED1_SHIFT)
#define  TESTIDMA_INT_FO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_FO_RESERVED1_MASK) | (((uint32_t)val) << TESTIDMA_INT_FO_RESERVED1_SHIFT))

#define  TESTIDMA_INT_FO_RRESP_INT_FO_MASK 0x20
#define  TESTIDMA_INT_FO_RRESP_INT_FO_SHIFT 5
#define  TESTIDMA_INT_FO_RRESP_INT_FO_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_FO_RRESP_INT_FO_MASK) >> TESTIDMA_INT_FO_RRESP_INT_FO_SHIFT)
#define  TESTIDMA_INT_FO_RRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_FO_RRESP_INT_FO_MASK) | (((uint32_t)val) << TESTIDMA_INT_FO_RRESP_INT_FO_SHIFT))

#define  TESTIDMA_INT_FO_BRESP_INT_FO_MASK 0x10
#define  TESTIDMA_INT_FO_BRESP_INT_FO_SHIFT 4
#define  TESTIDMA_INT_FO_BRESP_INT_FO_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_FO_BRESP_INT_FO_MASK) >> TESTIDMA_INT_FO_BRESP_INT_FO_SHIFT)
#define  TESTIDMA_INT_FO_BRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_FO_BRESP_INT_FO_MASK) | (((uint32_t)val) << TESTIDMA_INT_FO_BRESP_INT_FO_SHIFT))

#define  TESTIDMA_INT_FO_RST_INT_FO_MASK 0x8
#define  TESTIDMA_INT_FO_RST_INT_FO_SHIFT 3
#define  TESTIDMA_INT_FO_RST_INT_FO_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_FO_RST_INT_FO_MASK) >> TESTIDMA_INT_FO_RST_INT_FO_SHIFT)
#define  TESTIDMA_INT_FO_RST_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_FO_RST_INT_FO_MASK) | (((uint32_t)val) << TESTIDMA_INT_FO_RST_INT_FO_SHIFT))

#define  TESTIDMA_INT_FO_EOI_INT_FO_MASK 0x4
#define  TESTIDMA_INT_FO_EOI_INT_FO_SHIFT 2
#define  TESTIDMA_INT_FO_EOI_INT_FO_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_FO_EOI_INT_FO_MASK) >> TESTIDMA_INT_FO_EOI_INT_FO_SHIFT)
#define  TESTIDMA_INT_FO_EOI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_FO_EOI_INT_FO_MASK) | (((uint32_t)val) << TESTIDMA_INT_FO_EOI_INT_FO_SHIFT))

#define  TESTIDMA_INT_FO_FIN_INT_FO_MASK 0x2
#define  TESTIDMA_INT_FO_FIN_INT_FO_SHIFT 1
#define  TESTIDMA_INT_FO_FIN_INT_FO_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_FO_FIN_INT_FO_MASK) >> TESTIDMA_INT_FO_FIN_INT_FO_SHIFT)
#define  TESTIDMA_INT_FO_FIN_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_FO_FIN_INT_FO_MASK) | (((uint32_t)val) << TESTIDMA_INT_FO_FIN_INT_FO_SHIFT))

#define  TESTIDMA_INT_FO_WHO_INT_FO_MASK 0x1
#define  TESTIDMA_INT_FO_WHO_INT_FO_SHIFT 0
#define  TESTIDMA_INT_FO_WHO_INT_FO_MASK_SHIFT(reg) (((reg) & TESTIDMA_INT_FO_WHO_INT_FO_MASK) >> TESTIDMA_INT_FO_WHO_INT_FO_SHIFT)
#define  TESTIDMA_INT_FO_WHO_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_INT_FO_WHO_INT_FO_MASK) | (((uint32_t)val) << TESTIDMA_INT_FO_WHO_INT_FO_SHIFT))

//====================================================================
//Register: Descriptor Write Register (desc_write)
//====================================================================

#define  TESTIDMA_DESC_WRITE_DESC_MASK 0xffffffff
#define  TESTIDMA_DESC_WRITE_DESC_SHIFT 0
#define  TESTIDMA_DESC_WRITE_DESC_MASK_SHIFT(reg) (((reg) & TESTIDMA_DESC_WRITE_DESC_MASK) >> TESTIDMA_DESC_WRITE_DESC_SHIFT)
#define  TESTIDMA_DESC_WRITE_DESC_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_DESC_WRITE_DESC_MASK) | (((uint32_t)val) << TESTIDMA_DESC_WRITE_DESC_SHIFT))

//====================================================================
//Register: Descriptor Read Register (desc_read)
//====================================================================

#define  TESTIDMA_DESC_READ_DESC_MASK 0xffffffff
#define  TESTIDMA_DESC_READ_DESC_SHIFT 0
#define  TESTIDMA_DESC_READ_DESC_MASK_SHIFT(reg) (((reg) & TESTIDMA_DESC_READ_DESC_MASK) >> TESTIDMA_DESC_READ_DESC_SHIFT)
#define  TESTIDMA_DESC_READ_DESC_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_DESC_READ_DESC_MASK) | (((uint32_t)val) << TESTIDMA_DESC_READ_DESC_SHIFT))

//====================================================================
//Register: Descriptor Transfer Length Register (xfer_length)
//====================================================================

#define  TESTIDMA_XFER_LENGTH_LEN_MASK 0xffffffff
#define  TESTIDMA_XFER_LENGTH_LEN_SHIFT 0
#define  TESTIDMA_XFER_LENGTH_LEN_MASK_SHIFT(reg) (((reg) & TESTIDMA_XFER_LENGTH_LEN_MASK) >> TESTIDMA_XFER_LENGTH_LEN_SHIFT)
#define  TESTIDMA_XFER_LENGTH_LEN_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_XFER_LENGTH_LEN_MASK) | (((uint32_t)val) << TESTIDMA_XFER_LENGTH_LEN_SHIFT))

//====================================================================
//Register: Descriptor Transfer Address Register (xfer_addr)
//====================================================================

#define  TESTIDMA_XFER_ADDR_ADDR_MASK 0xffffffff
#define  TESTIDMA_XFER_ADDR_ADDR_SHIFT 0
#define  TESTIDMA_XFER_ADDR_ADDR_MASK_SHIFT(reg) (((reg) & TESTIDMA_XFER_ADDR_ADDR_MASK) >> TESTIDMA_XFER_ADDR_ADDR_SHIFT)
#define  TESTIDMA_XFER_ADDR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_XFER_ADDR_ADDR_MASK) | (((uint32_t)val) << TESTIDMA_XFER_ADDR_ADDR_SHIFT))

//====================================================================
//Register: Descriptor Control Word Register (ctrl_word)
//====================================================================

#define  TESTIDMA_CTRL_WORD_CTRL_WORD_MASK 0xffffffff
#define  TESTIDMA_CTRL_WORD_CTRL_WORD_SHIFT 0
#define  TESTIDMA_CTRL_WORD_CTRL_WORD_MASK_SHIFT(reg) (((reg) & TESTIDMA_CTRL_WORD_CTRL_WORD_MASK) >> TESTIDMA_CTRL_WORD_CTRL_WORD_SHIFT)
#define  TESTIDMA_CTRL_WORD_CTRL_WORD_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_CTRL_WORD_CTRL_WORD_MASK) | (((uint32_t)val) << TESTIDMA_CTRL_WORD_CTRL_WORD_SHIFT))

//====================================================================
//Register: Soft Reset register (reset)
//====================================================================

#define  TESTIDMA_RESET_RESERVED1_MASK 0xfffffffe
#define  TESTIDMA_RESET_RESERVED1_SHIFT 1
#define  TESTIDMA_RESET_RESERVED1_MASK_SHIFT(reg) (((reg) & TESTIDMA_RESET_RESERVED1_MASK) >> TESTIDMA_RESET_RESERVED1_SHIFT)
#define  TESTIDMA_RESET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_RESET_RESERVED1_MASK) | (((uint32_t)val) << TESTIDMA_RESET_RESERVED1_SHIFT))

#define  TESTIDMA_RESET_SOFT_RESET_MASK 0x1
#define  TESTIDMA_RESET_SOFT_RESET_SHIFT 0
#define  TESTIDMA_RESET_SOFT_RESET_MASK_SHIFT(reg) (((reg) & TESTIDMA_RESET_SOFT_RESET_MASK) >> TESTIDMA_RESET_SOFT_RESET_SHIFT)
#define  TESTIDMA_RESET_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_RESET_SOFT_RESET_MASK) | (((uint32_t)val) << TESTIDMA_RESET_SOFT_RESET_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  TESTIDMA_REV0_MAJ_MASK 0xffff0000
#define  TESTIDMA_REV0_MAJ_SHIFT 16
#define  TESTIDMA_REV0_MAJ_MASK_SHIFT(reg) (((reg) & TESTIDMA_REV0_MAJ_MASK) >> TESTIDMA_REV0_MAJ_SHIFT)
#define  TESTIDMA_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_REV0_MAJ_MASK) | (((uint32_t)val) << TESTIDMA_REV0_MAJ_SHIFT))

#define  TESTIDMA_REV0_MID_MASK 0xffff
#define  TESTIDMA_REV0_MID_SHIFT 0
#define  TESTIDMA_REV0_MID_MASK_SHIFT(reg) (((reg) & TESTIDMA_REV0_MID_MASK) >> TESTIDMA_REV0_MID_SHIFT)
#define  TESTIDMA_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_REV0_MID_MASK) | (((uint32_t)val) << TESTIDMA_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  TESTIDMA_REV1_RESERVED1_MASK 0xffff0000
#define  TESTIDMA_REV1_RESERVED1_SHIFT 16
#define  TESTIDMA_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & TESTIDMA_REV1_RESERVED1_MASK) >> TESTIDMA_REV1_RESERVED1_SHIFT)
#define  TESTIDMA_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_REV1_RESERVED1_MASK) | (((uint32_t)val) << TESTIDMA_REV1_RESERVED1_SHIFT))

#define  TESTIDMA_REV1_CFG_MASK 0xffff
#define  TESTIDMA_REV1_CFG_SHIFT 0
#define  TESTIDMA_REV1_CFG_MASK_SHIFT(reg) (((reg) & TESTIDMA_REV1_CFG_MASK) >> TESTIDMA_REV1_CFG_SHIFT)
#define  TESTIDMA_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~TESTIDMA_REV1_CFG_MASK) | (((uint32_t)val) << TESTIDMA_REV1_CFG_SHIFT))

#endif // ICE_TEST_DMA
