package com.ibm.jusb.os.linux;

/**
 * Copyright (c) 1999 - 2001, International Business Machines Corporation.
 * All Rights Reserved.
 *
 * This software is provided and licensed under the terms and conditions
 * of the Common Public License:
 * http://oss.software.ibm.com/developerworks/opensource/license-cpl.html
 */

import javax.usb.*;

/**
 * Proxy implementation for Linux's device-based access.
 * @author Dan Streetman
 */
class LinuxDeviceProxy extends LinuxRequestProxy
{
	/**
	 * Constructor.
	 * @param k The native key.  The key cannot be changed.
	 */
	public LinuxDeviceProxy(String k, int c)
	{
		super();
		key = k;
		cookie = c;
		
		JavaxUsbPropertyFileLoader jupf = new JavaxUsbPropertyFileLoader();
		jupf.loadProperties();
		interval = jupf.getInterval();
		sleep = jupf.getSleep();
	}

	//*************************************************************************
	// Public methods

	/** If this is running */
	public boolean isRunning()
	{
		try { return thread.isAlive(); }
		catch ( NullPointerException npE ) { return false; }
	}

	/** Start this proxy. */
	public void start() throws UsbException
	{
		Thread t = new Thread(proxyRunnable);

		t.setDaemon(true);
		t.setName("LinuxDeviceProxy " + getKey());

		synchronized (startLock) {
			t.start();

			try { startLock.wait(); }
			catch ( InterruptedException iE ) { }
		}

		if (0 != startError)
			throw JavaxUsb.errorToUsbException(startError, "Could not connect to USB device");
		else
			thread = t;
	}

	/**
	 * This is used in LinuxUsbServices to compare UsbDevicesImps.
	 * @return The native device key.
	 */
	public String getKey() { return key; }

	/**
	 * This is used in LinuxUsbServices to compare UsbDevicesImps.
	 * @return The native device cookie.
	 */
	public int getCookie() { return cookie; }
	
	/**
	 * This is used in JNI to set the interval.(Please refer to an external file(javaxusb.properties).)
	 * @return The interval setting.
	 */
	public int getInterval() { return interval; }

	/**
	 * This is used in JNI to set the sleep.(Please refer to an external file(javaxusb.properties).)
	 * @return The sleep setting.
	 */
	public int getSleep() { return sleep; }

	//*************************************************************************
	// JNI methods

	/**
	 * Signal startup completed.
	 * @param error The error number if startup failed, or 0 if startup succeeded.
	 */
	private void startCompleted( int error )
	{
		synchronized (startLock) {
			startError = error;

			startLock.notifyAll();
		}
	}

	//*************************************************************************
	// Instance variables

	private Thread thread = null;
	private String key = null;
	private int cookie = 0;
	private int interval = 0;
	private int sleep = 0;
	
	private Runnable proxyRunnable = new Runnable() {
		public void run()
		{ JavaxUsb.nativeDeviceProxy( LinuxDeviceProxy.this ); }
	};

	private Object startLock = new Object();
	private int startError = -1;

}
