/*
 * Copyright (C) 2007 RICOH Co.,LTD.
 * All rights reserved.
 *
 * Department   :  3rd@Development Section
 *                 2nd  Development Department
 *                 DSS  Development Center
 *                 DS&S (Document Solutions & Service) Division
 *
 * Purpose      :  RiMAP Software Development Kit
 *
 * $Name: not supported by cvs2svn $
 * $Date: 2009-04-16 03:59:37 $
 */

#ifndef _UHCOMM_H_
#define _UHCOMM_H_

//added by kawakubo
#include "usb.h"

struct usb_device_info_list_t;
typedef struct usb_device_info_list {
	struct usb_device_info_list_t* next;
	struct usb_device_info info;	/* (ugen defined) */
} usb_device_info_list_t;

/* MEMO (usb_device_info) from dev/usb/usb.h(ugen)

typedef struct { u_int32_t cookie; } usb_event_cookie_t;

#define USB_MAX_DEVNAMES 4
#define USB_MAX_DEVNAMELEN 16
struct usb_device_info {
	u_int8_t	bus;
	u_int8_t	addr;	// device address
	usb_event_cookie_t cookie;
	char		product[USB_MAX_STRING_LEN];
	char		vendor[USB_MAX_STRING_LEN];
	char		release[8];
	u_int16_t	productNo;
	u_int16_t	vendorNo;
	u_int16_t	releaseNo;
	u_int8_t	class;
	u_int8_t	subclass;
	u_int8_t	protocol;
	u_int8_t	config;
	u_int8_t	lowspeed;
	int		power;	// power consumption in mA, 0 if selfpowered
	int		nports;
	char		devnames[USB_MAX_DEVNAMES][USB_MAX_DEVNAMELEN];
	u_int8_t	ports[16];// hub only: addresses of devices on ports
#define USB_PORT_ENABLED 0xff
#define USB_PORT_SUSPENDED 0xfe
#define USB_PORT_POWERED 0xfd
#define USB_PORT_DISABLED 0xfc
};

*/

/**
 * return values
 */
/* usual */
#define UHCOMM_NORMAL 				0
#define UHCOMM_SOCKET_OK 			0
/* error (condition) */
#define UHCOMM_SOCKET_NG 			-1
#define UHCOMM_SOCKET_CLOSED 		-2
#define UHCOMM_HOST_NOT_EXIST 		-3
#define UHCOMM_INIT_BUSY 			-4
/* error (fatal) */
#define UHCOMM_MEMORY_ERROR 		-11
#define UHCOMM_PARAMETER_ERROR 		-12
#define UHCOMM_UNKNOWN_ERROR 		-13
#define UHCOMM_TARGET_NOT_FOUND 	-14
#define UHCOMM_INIT_ERROR 			-15


/* callback define */
/* event type */
#define UHCOMM_NCS_REBOOT 		2
#define UHCOMM_DEVICE_DETACH	3
#define UHCOMM_DEVICE_ATTACH	4
#define UHCOMM_DEVICE_UPDATE 	5
#define UHCOMM_ERROR_OCCURRED 	6
typedef void (*uhcomm_client_endpoint_t)(int, struct usb_device_info*);

/* callback regist function */
int uhcomm_register_endpoint(uhcomm_client_endpoint_t endpoint);

/* function */
int uhcomm_get_plugged_list (usb_device_info_list_t** list);
void uhcomm_release_plugged_list (usb_device_info_list_t* list);

#endif
