
/** 
 * Copyright (c) 1999 - 2001, International Business Machines Corporation.
 * All Rights Reserved.
 *
 * This software is provided and licensed under the terms and conditions
 * of the Common Public License:
 * http://oss.software.ibm.com/developerworks/opensource/license-cpl.html
 */

#include "JavaxUsb.h"
//added by kawakubo
#include "JavaxUsbUhCommunicator.h"
void uhcommEventHandler (int, struct usb_device_info*);
static pid_t g_pid;
static pthread_mutex_t listener_mutex = PTHREAD_MUTEX_INITIALIZER;	/* mutex for exclusive init */
/**
 * Listener for connect/disconnect events
 * @author Dan Streetman
 */
JNIEXPORT jint JNICALL Java_com_ibm_jusb_os_linux_JavaxUsb_nativeTopologyListener
			( JNIEnv *env, jclass JavaxUsb, jobject linuxUsbServices )
{
	int error = 0;
	jclass LinuxUsbServices = CheckedGetObjectClass( env, linuxUsbServices );

	jmethodID topologyChange = CheckedGetMethodID( env, LinuxUsbServices, "topologyChange", "()V" );

	sigset_t ss;
	int ret, signo;

	//set process id
	g_pid = getpid();

	pthread_mutex_lock(&listener_mutex);
	ret = uhcomm_register_endpoint(uhcommEventHandler);
	if(ret != UHCOMM_NORMAL){
		log( LOG_HOTPLUG_ERROR, "The method UhcommRegisterEndpoint is error.! %d ", ret);
		error = -1;
		pthread_mutex_unlock(&listener_mutex);
		CheckedDeleteLocalRef( env, LinuxUsbServices );
		return error;
	}
	
	errno = 0;
	while(1) {
		sigemptyset(&ss);
		ret = sigaddset(&ss, SIGUSR1);
		if (ret != 0){
			int errsv = USBERRNO;
			log( LOG_HOTPLUG_ERROR, "The method sigaddset is error.! %d : %s", errsv, strerror(errsv));
			error = -1;
			pthread_mutex_unlock(&listener_mutex);
			break;
		}
		ret = sigprocmask(SIG_BLOCK, &ss, NULL);
		if (ret != 0) {
			int errsv = USBERRNO;
			log( LOG_HOTPLUG_ERROR, "The method sigprocmask is error.! %d : %s", errsv, strerror(errsv));
			error = -1;
			pthread_mutex_unlock(&listener_mutex);
			break;
		}
		pthread_mutex_unlock(&listener_mutex);
		if (sigwait(&ss, &signo) == 0) {
			/* handle SIGUSR1 */
			pthread_mutex_lock(&listener_mutex);
			log( LOG_HOTPLUG_CHANGE, "Got topology change event." );
			CheckedCallVoidMethod( env, linuxUsbServices, topologyChange );
			continue;
		}
	}

	/* This should NOT happen! */
	log( LOG_HOTPLUG_CRITICAL, "TopologyListener Exiting!" );
	
	CheckedDeleteLocalRef( env, LinuxUsbServices );
	
	return error;

	
//	struct pollfd devpoll;
//	int poll_timeout = -1;
//	int descriptor = 0;
//	int error = 0;
//	unsigned int pollingError = 0;
//
//	jclass LinuxUsbServices = CheckedGetObjectClass( env, linuxUsbServices );
//
//	jmethodID topologyChange = CheckedGetMethodID( env, LinuxUsbServices, "topologyChange", "()V" );
//
//	errno = 0;
//	descriptor = open( USBDEVFS_DEVICES, O_RDONLY, 0 );
//	if ( 0 >= descriptor ) {
//		log( LOG_HOTPLUG_CRITICAL, "Could not open %s", USBDEVFS_DEVICES );
//		error = errno;
//		goto TOPOLOGY_LISTENER_CLEANUP;
//	}
//
//	devpoll.fd = descriptor;
//	devpoll.events = POLLIN;
//
//	while ( 1 ) {
//		poll(&devpoll, 1, poll_timeout);
//
//		// Skip empty wake-ups
//		if ( 0x0 == devpoll.revents ) continue;
//
//		// Polling Error...strange...
//		if ( devpoll.revents & POLLERR ) {
//			log( LOG_HOTPLUG_ERROR, "Topology Polling error." );
//			if (MAX_POLLING_ERRORS < ++pollingError) {
//				log( LOG_HOTPLUG_CRITICAL, "%d polling errors; aborting!", pollingError );
//				error = -ENOLINK; /* gotta pick one of 'em */
//				break;
//			} else continue;
//		}
//
//		// Connect/Disconnect event...
//		if ( devpoll.revents & POLLIN ) {
//			log( LOG_HOTPLUG_CHANGE, "Got topology change event." );
//			CheckedCallVoidMethod( env, linuxUsbServices, topologyChange );
//			continue;
//		}
//
//		// Freak event...
//		log( LOG_HOTPLUG_CHANGE, "Unknown event received = 0x%x", devpoll.revents );
//	}
//
//	/* This should NOT happen! */
//	log( LOG_HOTPLUG_CRITICAL, "TopologyListener Exiting!" );
//	close( descriptor );

//TOPOLOGY_LISTENER_CLEANUP:
//	CheckedDeleteLocalRef( env, LinuxUsbServices );
//
//	return error;
}
void uhcommEventHandler(int type, struct usb_device_info* info) 
{
	log( LOG_HOTPLUG_CHANGE, "Got topology change event. %d", type );
	
	if((type == UHCOMM_DEVICE_ATTACH) || (type == UHCOMM_DEVICE_DETACH)){
		sleep(1);
		pthread_mutex_lock(&listener_mutex);
		kill(g_pid, SIGUSR1);
		pthread_mutex_unlock(&listener_mutex);
		sleep(1);
	}
}
