
/** 
 * Copyright (c) 1999 - 2001, International Business Machines Corporation.
 * All Rights Reserved.
 *
 * This software is provided and licensed under the terms and conditions
 * of the Common Public License:
 * http://oss.software.ibm.com/developerworks/opensource/license-cpl.html
 */

#include "JavaxUsb.h"

/**
 * Submit a control pipe request.
 * @param env The JNIEnv.
 * @param fd The file descriptor.
 * @param linuxControlRequest The LinuxControlRequest.
 * @param usb The usbdevfs_urb.
 * @return The error that occurred, or 0.
 */
int control_pipe_request( JNIEnv *env, int fd, jobject linuxControlRequest, struct usbdevfs_urb *urb )
{
	int offset = 0;
	int ret = 0;
	struct usb_ctl_request ucr;

	jclass LinuxControlRequest = NULL;
	jmethodID getSetupPacket, getData, getOffset, getLength;
	jbyteArray setupPacket = NULL, data = NULL;
	//added by kawakubo
	jbyte* arrSrc = NULL;
	jboolean b;
	
	LinuxControlRequest = CheckedGetObjectClass( env, linuxControlRequest );
	getSetupPacket = CheckedGetMethodID( env, LinuxControlRequest, "getSetupPacket", "()[B" );
	getData = CheckedGetMethodID( env, LinuxControlRequest, "getData", "()[B" );
	getOffset = CheckedGetMethodID( env, LinuxControlRequest, "getOffset", "()I" );
	getLength = CheckedGetMethodID( env, LinuxControlRequest, "getLength", "()I" );
	setupPacket = CheckedCallObjectMethod( env, linuxControlRequest, getSetupPacket );
	data = CheckedCallObjectMethod( env, linuxControlRequest, getData );
	CheckedDeleteLocalRef( env, LinuxControlRequest );
	
	offset = (unsigned int)CheckedCallIntMethod( env, linuxControlRequest, getOffset );
	urb->buffer_length = (unsigned int)CheckedCallIntMethod( env, linuxControlRequest, getLength );

//	if (!(urb->buffer = malloc(urb->buffer_length + 8))) {
	//added by kawakubo
	if (!(urb->buffer = malloc(urb->buffer_length + 8))) {
		log( LOG_CRITICAL, "Out of memory!" );
		ret = -ENOMEM;
		goto END_SUBMIT;
	}

	ucr.flags = 0;
	ucr.actlen = 0;
	
	//setupPacket̎dl͈ȉB
	//	setupPacket[0] = bmRequestType();
	//	setupPacket[1] = bRequest();
	//	setupPacket[2] = (byte)wValue();
	//	setupPacket[3] = (byte)(wValue() >> 8);
	//	setupPacket[4] = (byte)wIndex();
	//	setupPacket[5] = (byte)(wIndex() >> 8);
	//	setupPacket[6] = (byte)wLength();
	//	setupPacket[7] = (byte)(wLength() >> 8);
	arrSrc=(*env)->GetByteArrayElements(env,setupPacket,&b);
	ucr.request.bmRequestType = arrSrc[0];
	ucr.request.bRequest = arrSrc[1];
	ucr.request.wValue[0] = arrSrc[2];
	ucr.request.wValue[1] = arrSrc[3];
	ucr.request.wIndex[0] = arrSrc[4];
	ucr.request.wIndex[1] = arrSrc[5];
	ucr.request.wLength[0] = arrSrc[6];
	ucr.request.wLength[1] = arrSrc[7];
	
//added by kawakubo
//	CheckedGetByteArrayRegion( env, setupPacket, 0, 8, urb->buffer );
//	CheckedGetByteArrayRegion( env, data, offset, urb->buffer_length, urb->buffer + 8 );
	CheckedGetByteArrayRegion( env, data, offset, urb->buffer_length, urb->buffer);

//	ucr.actlen = urb->buffer_length;
	ucr.data = (void *)urb->buffer;

	//Set Short Packet 
	//In control transfer mode, we allow short packet reading.
	//And after the processing, we check the short packet exception.
	//There is the difference sequence between the control transfer mode and the other transfer mode.
	//The reason is TCK.
	ucr.flags = USBD_SHORT_XFER_OK;		/* 0x04 allow short reads */

	/* Add 8 for the setup packet */
	//urb->buffer_length += 8;

	urb->type = getControlType();
	urb->flags = getControlFlags(urb->flags);
 
	debug_urb( env, "control_pipe_request", urb );
	debug_ucr( env, "control_pipe_request", &ucr );

	errno = 0;
    if (ioctl(fd, USB_DO_REQUEST, &ucr) < 0) {
		//In current ugen version, we can't get the usb special error status.
		//If we will be able to consider the value of USBERRNO, we have to add the source code.
    	int errsv = USBERRNO;
		if(errsv == 5){
			urb->status = USB_STALL_EXCEPTION;
			log( LOG_XFER_ERROR, "Failure of the control transfer mode. %d : %s", errsv, strerror(errsv));
			log( LOG_XFER_ERROR, "Failure of the control transfer mode. %d : USB_STALL_EXCEPTION", USB_STALL_EXCEPTION);
		}else{
			urb->status = -errsv;
			log( LOG_XFER_ERROR, "Failure of the bulk transfer mode. %d : %s", errsv, strerror(errsv));
		}
	}else if((ucr.actlen < urb->buffer_length) && (urb->flags & 0x0001)){//check short packet exception.
		urb->status = USB_SHORTPACKET_EXCEPTION;
		log( LOG_XFER_ERROR, "Failure of the control transfer mode. %d : USB_SHORTPACKET_EXCEPTION", USB_SHORTPACKET_EXCEPTION);
    }
    
	urb->actual_length = ucr.actlen;
	debug_ucr( env, "control_pipe_request", &ucr );

	///* Add 8 for the setup packet */
	//urb->buffer_length += 8;

	//urb->type = getControlType();
	//urb->flags = getControlFlags(urb->flags);

	//debug_urb( env, "control_pipe_request", urb );

	//errno = 0;
	//if (0 > (ioctl( fd, USBDEVFS_SUBMITURB, urb )))
	//	ret = -errno;

END_SUBMIT:
	if (ret)
		if (urb->buffer) free(urb->buffer);

	//added by kawakubo
	(*env)->ReleaseByteArrayElements(env, setupPacket, arrSrc, 0);
	if (setupPacket) CheckedDeleteLocalRef( env, setupPacket );
	if (data) CheckedDeleteLocalRef( env, data );
	
	return ret;
}

/**
 * Complete a control pipe request.
 * @param env The JNIEnv.
 * @param linuxControlRequest The LinuxControlRequest.
 * @param urb the usbdevfs_usb.
 * @return The error that occurred, or 0.
 */
int complete_control_pipe_request( JNIEnv *env, jobject linuxControlRequest, struct usbdevfs_urb *urb )
{
	jclass LinuxControlRequest = CheckedGetObjectClass( env, linuxControlRequest );
	jmethodID setActualLength = CheckedGetMethodID( env, LinuxControlRequest, "setActualLength", "(I)V" );
	jmethodID getData = CheckedGetMethodID( env, LinuxControlRequest, "getData", "()[B" );
	jmethodID getOffset = CheckedGetMethodID( env, LinuxControlRequest, "getOffset", "()I" );
	jmethodID getLength = CheckedGetMethodID( env, LinuxControlRequest, "getLength", "()I" );
	jbyteArray data = CheckedCallObjectMethod( env, linuxControlRequest, getData );
	unsigned int offset = (unsigned int)CheckedCallIntMethod( env, linuxControlRequest, getOffset );
	unsigned int length = (unsigned int)CheckedCallIntMethod( env, linuxControlRequest, getLength );
	CheckedDeleteLocalRef( env, LinuxControlRequest );

	if (length < urb->actual_length) {
		log( LOG_XFER_ERROR, "Actual length %d greater than requested length %d", urb->actual_length, length );
		urb->actual_length = length;
	}
//added by kawakubo
//	CheckedSetByteArrayRegion( env, data, offset, urb->actual_length, urb->buffer + 8 );
	CheckedSetByteArrayRegion( env, data, offset, urb->actual_length, urb->buffer);

	CheckedCallVoidMethod( env, linuxControlRequest, setActualLength, urb->actual_length );

	if (data) CheckedDeleteLocalRef( env, data );
	if (urb->buffer) free(urb->buffer);

	return urb->status;
}

/**
 * Set a configuration.
 * @param env The JNIEnv.
 * @param fd The file descriptor.
 * @param linuxSetConfigurationRequest The LinuxSetConfigurationRequest.
 * @return The error, or 0.
 */
//added by kawakubo
//int set_configuration( JNIEnv *env, int fd, jobject linuxSetConfigurationRequest )
int set_configuration( JNIEnv *env, int fd, jobject linuxSetConfigurationRequest, jstring javaKey, usefd_set* useFdSet )
{
	unsigned int *configuration = NULL;
	int ret = 0;
	int setfd = 0;

	jclass LinuxSetConfigurationRequest;
	jmethodID getConfiguration;

	LinuxSetConfigurationRequest = CheckedGetObjectClass( env, linuxSetConfigurationRequest );
	getConfiguration = CheckedGetMethodID( env, LinuxSetConfigurationRequest, "getConfiguration", "()I" );
	CheckedDeleteLocalRef( env, LinuxSetConfigurationRequest );

	if (!(configuration = malloc(sizeof(*configuration)))) {
		log( LOG_CRITICAL, "Out of memory!" );
		return -ENOMEM;
	}

	*configuration = (unsigned int)CheckedCallIntMethod( env, linuxSetConfigurationRequest, getConfiguration );

	log( LOG_XFER_META, "Setting configuration to %d", *configuration );

	//added by kawakubo
	errno = 0;
	setfd = open_device_control( env, javaKey, O_RDWR);
	if (0 > setfd) {
		int errsv = USBERRNO;
		ret = -errsv;
		log( LOG_XFER_ERROR, "Could not open node for device! %d : %s" , errsv, strerror(errsv));
		free(configuration);
		return ret;
	}
	errno = 0;
	//added by kawakubo
	//if (0 > (ioctl( fd, USBDEVFS_SETCONFIGURATION, configuration )))
	if (0 > (ioctl(setfd, USB_SET_CONFIG, configuration))){
		int errsv = USBERRNO;
		ret = -errsv;
		log( LOG_XFER_ERROR, "Could not set configuration (errno %d) : %s", errsv,  strerror(errsv));
	}else{
		log( LOG_XFER_META, "set_configuration : Set configuration" );
	}
	
	free(configuration);

	//added by kawakubo
	close(setfd);

	return ret;
}

/**
 * Set a interface setting.
 * @param env The JNIEnv.
 * @param fd The file descriptor.
 * @param linuxSetInterfaceRequest The LinuxSetInterfaceRequest.
 * @return The error, or 0.
 */
//added by kawakubo
//int set_interface( JNIEnv *env, int fd, jobject linuxSetInterfaceRequest )
int set_interface( JNIEnv *env, int fd, jobject linuxSetInterfaceRequest, jstring javaKey, usefd_set* useFdSet )
{
//added by kawakubo
	//	struct usbdevfs_setinterface *interface = NULL;
	struct usb_alt_interface *interface = NULL;
	int ret = 0;
	int setfd = 0;

	jclass LinuxSetInterfaceRequest;
	jmethodID getInterface, getSetting;

	LinuxSetInterfaceRequest = CheckedGetObjectClass( env, linuxSetInterfaceRequest );
	getInterface = CheckedGetMethodID( env, LinuxSetInterfaceRequest, "getInterface", "()I" );
	getSetting = CheckedGetMethodID( env, LinuxSetInterfaceRequest, "getSetting", "()I" );
	CheckedDeleteLocalRef( env, LinuxSetInterfaceRequest );

	if (!(interface = malloc(sizeof(*interface)))) {
		log( LOG_CRITICAL, "Out of memory!" );
		return -ENOMEM;
	}
	//interface->interface = (unsigned int)CheckedCallIntMethod( env, linuxSetInterfaceRequest, getInterface );
	//interface->altsetting = (unsigned int)CheckedCallIntMethod( env, linuxSetInterfaceRequest, getSetting );
	//interface.config_index is ignored.
	interface->interface_index = (unsigned int)CheckedCallIntMethod( env, linuxSetInterfaceRequest, getInterface );
	interface->alt_no = (unsigned int)CheckedCallIntMethod( env, linuxSetInterfaceRequest, getSetting );

	log( LOG_XFER_META, "Setting interface %d to setting %d", interface->interface_index, interface->alt_no );

//added by kawakubo
//	if (0 > (ioctl( fd, USBDEVFS_SETINTERFACE, interface )))

	errno = 0;
	setfd = open_device_control( env, javaKey, O_RDWR);
	if (0 > setfd) {
		int errsv = USBERRNO;
		ret = -errsv;
		log( LOG_XFER_ERROR, "Could not open node for device! %d : %s", errsv, strerror(errsv));
		free(interface);
		return ret;
	}

	errno = 0;
	if (0 > (ioctl( setfd, USB_SET_ALTINTERFACE, interface ))){
		int errsv = USBERRNO;
		ret = -errsv;	
		log( LOG_XFER_ERROR, "Could not set interface (errno %d) : %s", errsv, strerror(errsv) );
	}else{
		log( LOG_XFER_META, "Set interface" );
	}
	
	free(interface);
	close(setfd);

	return ret;
}

