/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: This class is useful for displaying panel.
 *
 *
 */
package jp.co.ricoh.dsdk.usb;

import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbHub;
import javax.usb.util.UsbUtil;

/**
 * This class is useful for displaying panel.
 */
public class UsbDeviceInfo {
	private int bus;
	
	private int parentport;

	private String idVendor;

	private String idProduct;
	
	private String bcdDevice;
	
	public UsbDeviceInfo(UsbDevice device){
			
		/** Get the bus information.*/
		UsbHub parentUsbHub = device.getParentUsbPort().getUsbHub();
		bus = parentUsbHub.getParentUsbPort().getPortNumber();
		while(!parentUsbHub.isRootUsbHub()){
			bus = parentUsbHub.getParentUsbPort().getPortNumber();
			parentUsbHub = parentUsbHub.getParentUsbPort().getUsbHub();
		}

		/** Get the other device information.*/
		parentport = (int)device.getParentUsbPort().getPortNumber();
		UsbDeviceDescriptor desc = device.getUsbDeviceDescriptor();
		idVendor=UsbUtil.toHexString(desc.idVendor());
		idProduct=UsbUtil.toHexString(desc.idProduct());
		bcdDevice=UsbUtil.toHexString(desc.bcdDevice());
	}
	
	public UsbDeviceInfo(int bus, int parentport, String idVendor, String idProduct, String bcdDevice) {
		this.bus = bus;
		this.parentport = parentport;
		this.idVendor = idVendor;
		this.idProduct = idProduct;
		this.bcdDevice = bcdDevice;
	}
	
	public String getBcdDevice() {
		return bcdDevice;
	}

	public int getBus() {
		return bus;
	}

	public String getIdProduct() {
		return idProduct;
	}

	public String getIdVendor() {
		return idVendor;
	}

	public int getParentport() {
		return parentport;
	}

	/**
	 * Returns a string representation of the object.
	 * @return String representation of this object
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer(100);
		sb.append("bus: ");
		sb.append(Integer.toString(bus));
		sb.append(", ");
		sb.append("parentport: ");
		sb.append(Integer.toString(parentport));
		sb.append(", ");
		sb.append("idVendor: ");
		sb.append(idVendor);
		sb.append(", ");
		sb.append("idProduct: ");
		sb.append(idProduct);
		sb.append(", ");
		sb.append("bcdDevice: ");
		sb.append(bcdDevice);
	
		return sb.toString();
	}

}
