/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	:  To show the http user interface.
 *
 *
 */
package jp.co.ricoh.dsdk.app.usb.test;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.usb.UsbDevice;
import javax.usb.UsbException;
import javax.usb.event.UsbServicesEvent;
import javax.usb.event.UsbServicesListener;

import jp.co.ricoh.dsdk.usb.UsbDeviceInfo;
import jp.co.ricoh.dsdk.usb.UsbDeviceManager;


/**
 * @author RICOH
 * 
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class UsbTestServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;

	private static final String SHOW_HEADER = "<html><head><title>Javax Usb Test for Server Type</title>" +
			"<meta http-equiv=\"content-script-type\" content=\"text/javascript\">" +
			"</head><body><TABLE>" +
			"<TR><TD><FORM name=\"USB\" method=\"GET\" action=\"./UsbTestServlet\"><INPUT type=\"submit\" name=\"PlugAndPlayTest\" value=\"Plug And Play Test\"/>" +
			"<br></FORM>" +
			"</TD></TR>" +
			"</TABLE>";
	public static final String SHOW_BOTTOM = "</body></html>";

	UsbDeviceManager device_reader = null;
	
	List devicePanelList = null;
	
	UsbServicesListener usl = null;

	public UsbTestServlet() {
		try {
			/** create usb device manager */
			this.device_reader = new UsbDeviceManager();
		} catch (UsbException e) {
			e.printStackTrace();
		}
		devicePanelList = new ArrayList();

		/** Get the UsbDevice list. */
		List list = device_reader.getDevices();
		for(int i = 0; i < list.size(); i++){
			DevicePanel panel = new DevicePanel((UsbDevice)list.get(i));	
			devicePanelList.add(panel);
		}
		
		/** create listener */
		createListener();
	}
	
	public void close() {
		System.out.println("start close");
		closeDevicePanelList();
		device_reader.removeServicesListener(usl);
	}
	
	/**
	 * @see javax.servlet.http.HttpServlet#void
	 *      (javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		System.out.println("call doGet");
		OutputStream out = null;
		Enumeration enu = req.getParameterNames();
		int count = 0;
		String name = null;	
		
		while(enu.hasMoreElements()){

			Object obj = enu.nextElement();
			if (obj instanceof String) {
				name = (String) obj;
			}
			count++;
			System.out.println("ParameterName[" + count + "] = " + name);
		}
			
		try {
			out = resp.getOutputStream();

			/** handle the parameter */
			if (name.startsWith("PlugAndPlayTest")) {
				System.out.println("PlugAndPlayTest");
				createUI(out);
			} 
			if (name.startsWith("GetData")) {
				System.out.println("In test GetData");
				
				/** specify the selecting device.*/
				List keyList = new ArrayList();
				StringTokenizer sst = new StringTokenizer(name, ",");
				while(sst.hasMoreTokens()){
					String token = sst.nextToken();
					keyList.add(token);
				}				
				
				int bus = Integer.parseInt((String)keyList.get(1));
				int parentport = Integer.parseInt((String)keyList.get(2)); 
				String idVendor = (String)keyList.get(3); 
				String idProduct = (String)keyList.get(4);
				String bcdDevice = (String)keyList.get(5);
				UsbDeviceInfo udi = new UsbDeviceInfo(bus, parentport, idVendor, idProduct, bcdDevice);
				start(out, udi);
			}
		} catch (Exception e) {
			out.write(e.getMessage().getBytes());
		} finally {
			out.close();
		}
	}
	/**
	 * @see javax.servlet.http.HttpServlet#void
	 *      (javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	public void doPost(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		System.out.println("In doPost()");
	}
	
	/**
	 * Start the obtaining.
	 * @param out output stream
	 * @param udi usb device information.
	 */
	private void start(OutputStream out, UsbDeviceInfo udi) {
		System.out.println("devicePanelList size = " + devicePanelList.size());
		
		/** Compare the devices.*/
		for(int i = 0; i < devicePanelList.size(); i++){
			DevicePanel panel = (DevicePanel)devicePanelList.get(i);
			UsbDeviceInfo moto_udi = panel.getUdi();
			if(isEqualDevice(moto_udi, udi)){
				panel.start();
				break;
			}
		}
		createUI(out);
	}
	/**
	 * Compare data1 and data2.
	 * @param udi_moto data1
	 * @param udi data2
	 * @return true:data1=data2, false:data1 != data2
	 */
	private boolean isEqualDevice(UsbDeviceInfo udi_moto, UsbDeviceInfo udi){
		if((udi_moto.getBus() == udi.getBus()) &&
				(udi_moto.getBcdDevice().equals(udi.getBcdDevice())) &&
				(udi_moto.getParentport() == udi.getParentport()) &&
				(udi_moto.getIdProduct().equals(udi.getIdProduct())) &&				
				(udi_moto.getIdVendor().equals(udi.getIdVendor())))
		{
			return true;
		}
				
		return false;
	}
	
	/**
	 * {@jp GUI쐬}{@en create GUI}.
	 */
	private void createUI(OutputStream out) {
		System.out.println("start showDisplay");
		StringBuffer sb = new StringBuffer(200);
		StringBuffer sb_dp = new StringBuffer(100);

		int size_old = devicePanelList.size();

		for(int i = 0; i < devicePanelList.size(); i++){
			DevicePanel dp = (DevicePanel)devicePanelList.get(i);
			sb_dp.append(dp.getShowString());
			sb_dp.append("<br><br>");
		}
		
		//check the current status.
		int size_new = devicePanelList.size();
	
		if(size_new == 0){
			try {
				sb.append(SHOW_HEADER);
				sb.append(SHOW_BOTTOM);
				out.write(sb.toString().getBytes());
				System.out.println("No Device!");
				out.write("No Device!".getBytes());
			} catch (IOException e) {
				e.printStackTrace();
			}
		}else if(size_new != size_old){
			createUI(out);
		}else{
			try{
				sb.append(SHOW_HEADER);
				sb.append(sb_dp.toString());
				sb.append(SHOW_BOTTOM);
				out.write(sb.toString().getBytes());
			} catch (IOException e) {
				e.printStackTrace();
			}		
		}
	}
	
	/**
	 * {@jp UsbfoCX񂪍XVꂽƂɌĂ΂}{@en Create the listener}.
	 */
	private void createListener(){
		System.out.println("In createListener");

		/** foCXXVꂽꍇɌĂяo */
		/** When the device was attached or dettached, the UsbServicesListener class is called.*/
		usl = new UsbServicesListener() {
			public void usbDeviceAttached(UsbServicesEvent use) {
				System.out.println("usbDeviceAttached");
				//closeDevicePanelList();
				DevicePanel panel = new DevicePanel(use.getUsbDevice());	
				devicePanelList.add(panel);
				
//				updateDevice();
			}
			public void usbDeviceDetached(UsbServicesEvent use) {
				System.out.println("usbDeviceDetached");
				/** Remove the device panel from devicePanelList.*/
				for(int i = 0; i < devicePanelList.size(); i++){
					DevicePanel dp = (DevicePanel)devicePanelList.get(i);
					UsbDevice ud = dp.getDevice();
					if(ud != use.getUsbDevice()){
						//dp.closeDevicePanel();
					}else{
						dp.stop();
						devicePanelList.remove(i);
					}
				}
//				updateDevice();
			}
		};
		device_reader.addUsbServicesListener(usl);
		System.out.println("Out createListener");
	}
	
	/**
	 * Close the all devicePanel class.
	 */
	private void closeDevicePanelList(){
		/** Close the old USB device*/
		if(devicePanelList != null){
			for(int i =0; i < this.devicePanelList.size(); i++){
				DevicePanel dp = (DevicePanel)devicePanelList.get(i);
				if(dp.isStart_flag()){
					dp.closeDevicePanel();
				}
			}
		}
	}
}


