/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: This class show the device information to the panel.
 *
 *
 */
package jp.co.ricoh.dsdk.app.usb.test;

import javax.usb.UsbDevice;
import javax.usb.UsbException;

import jp.co.ricoh.dsdk.usb.UsbDeviceInfo;
import jp.co.ricoh.dsdk.usb.prox.CardListener;
import jp.co.ricoh.dsdk.usb.prox.CardReaderManager;
import jp.co.ricoh.dsdk.usb.prox.CardReaderService;

/**
 * {@jp Device\ƂɎgpClass}{@en }.
 * {@jp {ContainerNXpĂ邽߁Athis.add()gpB}
 * {@jp AgpsƂȂĂBContainerWindowł邱Ƃz肳ĂȂB}
 * {@jp Container.java Line.136` Line.146B}
 * {@en This class show the device information to the panel.}
 */
public class DevicePanel {

	private static final long serialVersionUID = 1L;

	/**
	 * the base device information
	 */
	private UsbDevice device = null;
	
	private UsbDeviceInfo udi;
	
	private CardReaderService reader;

	private CardListener listener = null;
	
	/**
	 * Card data is input. 
	 */
	private String devicedata = "";

	private boolean start_flag = false;
	
	/**
	 * {@jp DevicePanelNX𐶐}{@en Create DevicePanel}.
	 * @param device {@jp UsbDeice}{@en }.
	 */
	public DevicePanel(final UsbDevice device){
		System.out.println("start DevicePanel Constructor");
		this.device = device;
		udi = new UsbDeviceInfo(device);
		System.out.println("device information =" + udi.toString());
		try {
			reader = CardReaderManager.getCardReaderService(device, Activator.INSTALL_PATH);
		} catch (UsbException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * close the DevicePanel.
	 */
	public void closeDevicePanel(){
		System.out.println("start closeDevicePanel");
		reader.stopReader();
		try {
			if(!start_flag){
				reader.releaseUsbInterface();
			}
		} catch (UsbException e) {
			e.printStackTrace();
		}
		reader.removeListener(listener);
		start_flag = false;
		System.out.println("end closeDevicePanel");
	}
	
	/**
	 * Start the obtaining.
	 */
	public void start() {
//System.out.println("In createListener : in DevicePanel");
	
		start_flag = true;
		
		/** CardDeviceListenerɃCxgǉ */
		/** When the data is received from the usb device, the CardListner class is called.*/
		/** If the listener had already existed, listener isn't set.*/
		if(listener == null){
			listener = new CardListener(){
				public void readByte(byte[] data) {
		//				System.out.print("ThirdData = ");
//					for (int i = 0; i < data.length; i++) {
//						System.out.print(data[i] + " ");
//					}
//					System.out.println(" ");
					System.out.println("RESULT = " + new String(data));
					devicedata = new String(data);
					reader.stopReader();

					start_flag = false;
				}
				public void disconnect() {
					System.out.println("disconnect");
					reader.stopReader();
					reader.removeListener(listener);
					start_flag = false;
				}
			};
			reader.addListener(listener);
		}
		reader.startReader();
		System.out.println("end DevicePanel.start");
	}
	/**
	 * Stop the obtaining.
	 */
	public void stop() {
		start_flag = false;
	}

	/**
	 * Return the information about displaying.
	 * @return display information.
	 */
	public String getShowString() {
		/** Wait forever until obtaining the data from the usb device. */
		while(start_flag){
			try {
				System.out.println("wait...");
				System.out.println("dd = " + this.devicedata);
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		
		StringBuffer sb = new StringBuffer(100);
		sb.append("<table border=\"1\">");
		sb.append("<tr bgcolor=\"eeeeff\"><th align=\"left\" colspan=\"2\"><b>Device Information</b></th></tr>");
		sb.append("<tr><td>bus</td><td>" + Integer.toString(udi.getBus()) + "</td></tr>");
		sb.append("<tr><td>parentport</td><td>" + Integer.toString(udi.getParentport()) + "</td></tr>");
		sb.append("<tr><td>idVender</td><td>" + udi.getIdVendor() + "</td></tr>");
		sb.append("<tr><td>idProductt</td><td>" + udi.getIdProduct() + "</td></tr>");
		sb.append("<tr><td>bcdDevice</td><td>" + udi.getBcdDevice() + "</td></tr>");
		sb.append("<tr><td>	<FORM name=\"USB\" method=\"GET\" action=\"./UsbTestServlet\"><INPUT type=\"submit\" name=\"GetData");
		sb.append("," + Integer.toString(udi.getBus()));
		sb.append("," + Integer.toString(udi.getParentport()));
		sb.append("," + udi.getIdVendor());
		sb.append("," + udi.getIdProduct());
		sb.append("," + udi.getBcdDevice() + "\"");
		sb.append(" value=\"Get Data\"/><br></FORM></td><td>" + this.devicedata + "</td></tr>");
		sb.append("</table>");
		
		return sb.toString();
	}

	
	/**
	 * Return the usb device information.
	 * @return usb device information.
	 */
	public UsbDeviceInfo getUdi() {
		return udi;
	}
	/**
	 * Return the status.
	 * @return status.
	 */
	public boolean isStart_flag() {
		return start_flag;
	}
	
	/**
	 * Return the usb device which set by the constructor.
	 * @return usb device
	 */
	public UsbDevice getDevice() {
		return device;
	}
}
