/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: CardReaderService is an interface to mount the processing of UsbCardReader.
 *
 *
 */
package jp.co.ricoh.dsdk.usb.prox;

import javax.usb.UsbDevice;
import javax.usb.UsbException;

/**
 * CardReaderServiceC^[tFCX́AUsbCardReadeȑ邽߂̃C^[tFCXłB
 * CardReaderƂɁÃC^[tFCXKv܂B
 * card.reader.propertiesvenderIDCardReaderServiceNX̑ΉLqĂKv܂B
 * CardReaderService is an interface to mount the processing of UsbCardReader. 
 */
public interface CardReaderService {

	/**
	 * CardReaderServiceCardListenero^܂B
	 * Register CardListener in CardReaderService. 
	 */
	void addListener(CardListener lis);
	
	/**
	 * CardReaderServiceCardListener폜܂B
	 * Delete CardListener in CardReaderService. 
	 */
	void removeListener(CardListener lis);
	
	/**
	 * CardReaderServiceɏǂݍ݂UsbDeviceo^܂B
	 * o^UsbDevicevendorIDCardReaderServiceNXcard.reader.propertiesɋLqĂ邱ƂKvłB
	 * Set UsbDevice that reads CardReaderService information.
	 * It is necessary to describe the class that mounts CardReaderService and vendorID in card.reader.properties. file.
	 */
	void setDevice(UsbDevice device)throws UsbException;
	
	/**
	 * CardReaderServiceɓo^ĂUsbService擾܂B
	 * Get UsbService registered in this CardReaderService. 
	 */
	UsbDevice getDevice();
	
	/**
	 * UsbCardReader̓ǂݎJn܂B
	 * ̃\bh̎ThreadgĎĉB
	 * Start reading UsbCardReader. 
	 * It's necessary to use Thread class on mounting this method. 
	 */
	void startReader();
	
	/**
	 * CardReader̓ǂݎ~܂B
	 * Stop reading CardReader. 
	 */
	void stopReader();
	
	/**
	 * UsbCardReaderǂݎ蒆~𔻒肵܂B
	 * Return whether this UsbCardReader is reading or stopping. 
	 */
	boolean isReading();
	
	/**
	 * UsbCardReaderUsbInterface[X܂B
	 * Release UsbInterface of this UsbCardReader.
	 */
	void releaseUsbInterface()throws UsbException;

}
